// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A specific representation of configurable options for a MongoDB chat extension configuration.
 */
@Immutable
public final class MongoDBChatExtensionConfiguration extends AzureChatExtensionConfiguration {

    /*
     * The label for the type of an Azure chat extension. This typically corresponds to a matching Azure resource.
     * Azure chat extensions are only compatible with Azure OpenAI.
     */
    @Generated
    private AzureChatExtensionType type = AzureChatExtensionType.MONGO_DB;

    /*
     * The parameters for the MongoDB chat extension.
     */
    @Generated
    private final MongoDBChatExtensionParameters parameters;

    /**
     * Creates an instance of MongoDBChatExtensionConfiguration class.
     *
     * @param parameters the parameters value to set.
     */
    @Generated
    public MongoDBChatExtensionConfiguration(MongoDBChatExtensionParameters parameters) {
        this.parameters = parameters;
    }

    /**
     * Get the type property: The label for the type of an Azure chat extension. This typically corresponds to a
     * matching Azure resource.
     * Azure chat extensions are only compatible with Azure OpenAI.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public AzureChatExtensionType getType() {
        return this.type;
    }

    /**
     * Get the parameters property: The parameters for the MongoDB chat extension.
     *
     * @return the parameters value.
     */
    @Generated
    public MongoDBChatExtensionParameters getParameters() {
        return this.parameters;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", this.parameters);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MongoDBChatExtensionConfiguration from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MongoDBChatExtensionConfiguration if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MongoDBChatExtensionConfiguration.
     */
    @Generated
    public static MongoDBChatExtensionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MongoDBChatExtensionParameters parameters = null;
            AzureChatExtensionType type = AzureChatExtensionType.MONGO_DB;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    parameters = MongoDBChatExtensionParameters.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = AzureChatExtensionType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            MongoDBChatExtensionConfiguration deserializedMongoDBChatExtensionConfiguration
                = new MongoDBChatExtensionConfiguration(parameters);
            deserializedMongoDBChatExtensionConfiguration.type = type;
            return deserializedMongoDBChatExtensionConfiguration;
        });
    }
}
