// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The details of a a vectorization source, used by Azure OpenAI On Your Data when applying vector search, that is based
 * on a search service model ID. Currently only supported by Elasticsearch®.
 */
@Immutable
public final class OnYourDataModelIdVectorizationSource extends OnYourDataVectorizationSource {

    /*
     * The embedding model ID build inside the search service. Currently only supported by Elasticsearch®.
     */
    @Generated
    private final String modelId;

    /**
     * Creates an instance of OnYourDataModelIdVectorizationSource class.
     *
     * @param modelId the modelId value to set.
     */
    @Generated
    public OnYourDataModelIdVectorizationSource(String modelId) {
        this.modelId = modelId;
    }

    /**
     * Get the modelId property: The embedding model ID build inside the search service. Currently only supported by
     * Elasticsearch®.
     *
     * @return the modelId value.
     */
    @Generated
    public String getModelId() {
        return this.modelId;
    }

    /*
     * The type of vectorization source to use.
     */
    @Generated
    private OnYourDataVectorizationSourceType type = OnYourDataVectorizationSourceType.MODEL_ID;

    /**
     * Get the type property: The type of vectorization source to use.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public OnYourDataVectorizationSourceType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("model_id", this.modelId);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OnYourDataModelIdVectorizationSource from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of OnYourDataModelIdVectorizationSource if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OnYourDataModelIdVectorizationSource.
     */
    @Generated
    public static OnYourDataModelIdVectorizationSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String modelId = null;
            OnYourDataVectorizationSourceType type = OnYourDataVectorizationSourceType.MODEL_ID;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("model_id".equals(fieldName)) {
                    modelId = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = OnYourDataVectorizationSourceType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            OnYourDataModelIdVectorizationSource deserializedOnYourDataModelIdVectorizationSource
                = new OnYourDataModelIdVectorizationSource(modelId);
            deserializedOnYourDataModelIdVectorizationSource.type = type;
            return deserializedOnYourDataModelIdVectorizationSource;
        });
    }
}
