// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The authentication options for Azure OpenAI On Your Data vector search.
 */
@Immutable
public class OnYourDataVectorSearchAuthenticationOptions
    implements JsonSerializable<OnYourDataVectorSearchAuthenticationOptions> {

    /*
     * The type of authentication to use.
     */
    @Generated
    private OnYourDataVectorSearchAuthenticationType type
        = OnYourDataVectorSearchAuthenticationType.fromString("OnYourDataVectorSearchAuthenticationOptions");

    /**
     * Creates an instance of OnYourDataVectorSearchAuthenticationOptions class.
     */
    @Generated
    public OnYourDataVectorSearchAuthenticationOptions() {
    }

    /**
     * Get the type property: The type of authentication to use.
     *
     * @return the type value.
     */
    @Generated
    public OnYourDataVectorSearchAuthenticationType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OnYourDataVectorSearchAuthenticationOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of OnYourDataVectorSearchAuthenticationOptions if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OnYourDataVectorSearchAuthenticationOptions.
     */
    @Generated
    public static OnYourDataVectorSearchAuthenticationOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("api_key".equals(discriminatorValue)) {
                    return OnYourDataVectorSearchApiKeyAuthenticationOptions.fromJson(readerToUse.reset());
                } else if ("access_token".equals(discriminatorValue)) {
                    return OnYourDataVectorSearchAccessTokenAuthenticationOptions.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static OnYourDataVectorSearchAuthenticationOptions fromJsonKnownDiscriminator(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            OnYourDataVectorSearchAuthenticationOptions deserializedOnYourDataVectorSearchAuthenticationOptions
                = new OnYourDataVectorSearchAuthenticationOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedOnYourDataVectorSearchAuthenticationOptions.type
                        = OnYourDataVectorSearchAuthenticationType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedOnYourDataVectorSearchAuthenticationOptions;
        });
    }
}
