/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class AudioResponseData
implements JsonSerializable<AudioResponseData> {
    private final String id;
    private final long expiresAt;
    private final String data;
    private final String transcript;

    private AudioResponseData(String id, OffsetDateTime expiresAt, String data, String transcript) {
        this.id = id;
        this.expiresAt = expiresAt == null ? 0L : expiresAt.toEpochSecond();
        this.data = data;
        this.transcript = transcript;
    }

    public String getId() {
        return this.id;
    }

    public OffsetDateTime getExpiresAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expiresAt), ZoneOffset.UTC);
    }

    public String getData() {
        return this.data;
    }

    public String getTranscript() {
        return this.transcript;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeLongField("expires_at", this.expiresAt);
        jsonWriter.writeStringField("data", this.data);
        jsonWriter.writeStringField("transcript", this.transcript);
        return jsonWriter.writeEndObject();
    }

    public static AudioResponseData fromJson(JsonReader jsonReader) throws IOException {
        return (AudioResponseData)jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime expiresAt = null;
            String data = null;
            String transcript = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("expires_at".equals(fieldName)) {
                    expiresAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("data".equals(fieldName)) {
                    data = reader.getString();
                    continue;
                }
                if ("transcript".equals(fieldName)) {
                    transcript = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new AudioResponseData(id, expiresAt, data, transcript);
        });
    }
}

