/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureChatExtensionDataSourceResponseCitation
implements JsonSerializable<AzureChatExtensionDataSourceResponseCitation> {
    private final String content;
    private String title;
    private String url;
    private String filepath;
    private String chunkId;
    private Double rerankScore;

    private AzureChatExtensionDataSourceResponseCitation(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public String getChunkId() {
        return this.chunkId;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("filepath", this.filepath);
        jsonWriter.writeStringField("chunk_id", this.chunkId);
        jsonWriter.writeNumberField("rerank_score", (Number)this.rerankScore);
        return jsonWriter.writeEndObject();
    }

    public static AzureChatExtensionDataSourceResponseCitation fromJson(JsonReader jsonReader) throws IOException {
        return (AzureChatExtensionDataSourceResponseCitation)jsonReader.readObject(reader -> {
            String content = null;
            String title = null;
            String url = null;
            String filepath = null;
            String chunkId = null;
            Double rerankScore = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("title".equals(fieldName)) {
                    title = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    url = reader.getString();
                    continue;
                }
                if ("filepath".equals(fieldName)) {
                    filepath = reader.getString();
                    continue;
                }
                if ("chunk_id".equals(fieldName)) {
                    chunkId = reader.getString();
                    continue;
                }
                if ("rerank_score".equals(fieldName)) {
                    rerankScore = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            AzureChatExtensionDataSourceResponseCitation deserializedAzureChatExtensionDataSourceResponseCitation = new AzureChatExtensionDataSourceResponseCitation(content);
            deserializedAzureChatExtensionDataSourceResponseCitation.title = title;
            deserializedAzureChatExtensionDataSourceResponseCitation.url = url;
            deserializedAzureChatExtensionDataSourceResponseCitation.filepath = filepath;
            deserializedAzureChatExtensionDataSourceResponseCitation.chunkId = chunkId;
            deserializedAzureChatExtensionDataSourceResponseCitation.rerankScore = rerankScore;
            return deserializedAzureChatExtensionDataSourceResponseCitation;
        });
    }

    public Double getRerankScore() {
        return this.rerankScore;
    }
}

