/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRole;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatRequestDeveloperMessage
extends ChatRequestMessage {
    private ChatRole role = ChatRole.DEVELOPER;
    private final BinaryData content;
    private String name;

    public ChatRequestDeveloperMessage(BinaryData content) {
        this.content = content;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    public BinaryData getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public ChatRequestDeveloperMessage setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeFieldName("content");
        this.content.writeTo(jsonWriter);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestDeveloperMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestDeveloperMessage)jsonReader.readObject(reader -> {
            BinaryData content = null;
            ChatRole role = ChatRole.DEVELOPER;
            String name = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ChatRequestDeveloperMessage deserializedChatRequestDeveloperMessage = new ChatRequestDeveloperMessage(content);
            deserializedChatRequestDeveloperMessage.role = role;
            deserializedChatRequestDeveloperMessage.name = name;
            return deserializedChatRequestDeveloperMessage;
        });
    }
}

