/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class FunctionCall
implements JsonSerializable<FunctionCall> {
    private final String name;
    private final String arguments;

    public FunctionCall(String name, String arguments) {
        this.name = name;
        this.arguments = arguments;
    }

    public String getName() {
        return this.name;
    }

    public String getArguments() {
        return this.arguments;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("arguments", this.arguments);
        return jsonWriter.writeEndObject();
    }

    public static FunctionCall fromJson(JsonReader jsonReader) throws IOException {
        return (FunctionCall)jsonReader.readObject(reader -> {
            String name = null;
            String arguments = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("arguments".equals(fieldName)) {
                    arguments = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new FunctionCall(name, arguments);
        });
    }
}

