/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses;

import com.azure.ai.openai.implementation.OpenAIUtils;
import com.azure.ai.openai.responses.ResponsesClientBuilder;
import com.azure.ai.openai.responses.implementation.NonAzureResponsesClientImpl;
import com.azure.ai.openai.responses.implementation.OpenAIServerSentEvents;
import com.azure.ai.openai.responses.implementation.ResponsesClientImpl;
import com.azure.ai.openai.responses.implementation.accesshelpers.CreateResponsesRequestAccessHelper;
import com.azure.ai.openai.responses.models.CreateResponseRequestAccept;
import com.azure.ai.openai.responses.models.CreateResponsesRequest;
import com.azure.ai.openai.responses.models.CreateResponsesRequestIncludable;
import com.azure.ai.openai.responses.models.DeleteResponseResponse;
import com.azure.ai.openai.responses.models.ListInputItemsRequestOrder;
import com.azure.ai.openai.responses.models.ResponsesInputItemList;
import com.azure.ai.openai.responses.models.ResponsesItem;
import com.azure.ai.openai.responses.models.ResponsesResponse;
import com.azure.ai.openai.responses.models.ResponsesStreamEvent;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.IterableStream;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;

@ServiceClient(builder=ResponsesClientBuilder.class)
public final class ResponsesClient {
    private final ResponsesClientImpl serviceClient;
    private final NonAzureResponsesClientImpl nonAzureServiceClient;

    ResponsesClient(ResponsesClientImpl serviceClient) {
        this.serviceClient = serviceClient;
        this.nonAzureServiceClient = null;
    }

    ResponsesClient(NonAzureResponsesClientImpl serviceClient) {
        this.serviceClient = null;
        this.nonAzureServiceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createResponseWithResponse(String accept, BinaryData requestBody, RequestOptions requestOptions) {
        if (this.nonAzureServiceClient != null) {
            return this.nonAzureServiceClient.createResponseWithResponse(accept, requestBody, requestOptions);
        }
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createResponseWithResponse(accept, requestBody, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> getResponseWithResponse(String responseId, RequestOptions requestOptions) {
        if (this.nonAzureServiceClient != null) {
            return this.nonAzureServiceClient.getResponseWithResponse(responseId, requestOptions);
        }
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getResponseWithResponse(responseId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> listInputItemsWithResponse(String responseId, RequestOptions requestOptions) {
        if (this.nonAzureServiceClient != null) {
            return this.nonAzureServiceClient.listInputItemsWithResponse(responseId, requestOptions);
        }
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listInputItemsWithResponse(responseId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponsesResponse getResponse(String responseId, List<CreateResponsesRequestIncludable> includables) {
        RequestOptions requestOptions = new RequestOptions();
        if (includables != null) {
            for (CreateResponsesRequestIncludable paramItemValue : includables) {
                if (paramItemValue == null) continue;
                requestOptions.addQueryParam("include[]", paramItemValue.toString(), false);
            }
        }
        return (ResponsesResponse)((BinaryData)this.getResponseWithResponse(responseId, requestOptions).getValue()).toObject(ResponsesResponse.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponsesResponse getResponse(String responseId) {
        RequestOptions requestOptions = new RequestOptions();
        return (ResponsesResponse)((BinaryData)this.getResponseWithResponse(responseId, requestOptions).getValue()).toObject(ResponsesResponse.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResponsesItem> listInputItems(String responseId, Integer limit, ListInputItemsRequestOrder order) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        return new PagedIterable(() -> {
            Response<BinaryData> response = this.listInputItemsWithResponse(responseId, requestOptions);
            ResponsesInputItemList pagedItems = (ResponsesInputItemList)((BinaryData)response.getValue()).toObject(ResponsesInputItemList.class);
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), pagedItems.getData(), pagedItems.isHasMore() ? pagedItems.getLastId() : null, (Object)response.getHeaders());
        }, nextLink -> {
            RequestOptions nextPageRequestOptions = new RequestOptions();
            if (limit != null) {
                nextPageRequestOptions.addQueryParam("limit", String.valueOf(limit), false);
            }
            if (order != null) {
                nextPageRequestOptions.addQueryParam("order", order.toString(), false);
            }
            nextPageRequestOptions.addQueryParam("after", nextLink, false);
            Response<BinaryData> response = this.listInputItemsWithResponse(responseId, nextPageRequestOptions);
            ResponsesInputItemList pagedItems = (ResponsesInputItemList)((BinaryData)response.getValue()).toObject(ResponsesInputItemList.class);
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), pagedItems.getData(), pagedItems.isHasMore() ? pagedItems.getLastId() : null, (Object)response.getHeaders());
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private ResponsesResponse createResponse(CreateResponseRequestAccept accept, CreateResponsesRequest requestBody) {
        RequestOptions requestOptions = new RequestOptions();
        return (ResponsesResponse)((BinaryData)this.createResponseWithResponse(accept.toString(), BinaryData.fromObject((Object)requestBody), requestOptions).getValue()).toObject(ResponsesResponse.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponsesResponse createResponse(CreateResponsesRequest requestBody, RequestOptions requestOptions) {
        CreateResponsesRequestAccessHelper.setStream(requestBody, false);
        return (ResponsesResponse)((BinaryData)this.createResponseWithResponse(CreateResponseRequestAccept.APPLICATION_JSON.toString(), BinaryData.fromObject((Object)requestBody), requestOptions).getValue()).toObject(ResponsesResponse.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponsesResponse createResponse(CreateResponsesRequest requestBody) {
        CreateResponsesRequestAccessHelper.setStream(requestBody, false);
        RequestOptions requestOptions = new RequestOptions();
        return (ResponsesResponse)((BinaryData)this.createResponseWithResponse(CreateResponseRequestAccept.APPLICATION_JSON.toString(), BinaryData.fromObject((Object)requestBody), requestOptions).getValue()).toObject(ResponsesResponse.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<ResponsesStreamEvent> createResponseStreaming(CreateResponsesRequest requestBody, RequestOptions requestOptions) {
        CreateResponsesRequestAccessHelper.setStream(requestBody, true);
        Flux events = ((BinaryData)this.createResponseWithResponse(CreateResponseRequestAccept.TEXT_EVENT_STREAM.toString(), BinaryData.fromObject((Object)requestBody), requestOptions).getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents eventsProcessor = new OpenAIServerSentEvents((Flux<ByteBuffer>)events);
        return new IterableStream(eventsProcessor.getEvents());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<ResponsesStreamEvent> createResponseStreaming(CreateResponsesRequest requestBody) {
        RequestOptions requestOptions = new RequestOptions();
        CreateResponsesRequestAccessHelper.setStream(requestBody, true);
        Flux events = ((BinaryData)this.createResponseWithResponse(CreateResponseRequestAccept.TEXT_EVENT_STREAM.toString(), BinaryData.fromObject((Object)requestBody), requestOptions).getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents eventsProcessor = new OpenAIServerSentEvents((Flux<ByteBuffer>)events);
        return new IterableStream(eventsProcessor.getEvents());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteResponseWithResponse(String responseId, RequestOptions requestOptions) {
        if (this.nonAzureServiceClient != null) {
            return this.nonAzureServiceClient.deleteResponseWithResponse(responseId, requestOptions);
        }
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.deleteResponseWithResponse(responseId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeleteResponseResponse deleteResponse(String responseId, RequestOptions requestOptions) {
        return (DeleteResponseResponse)((BinaryData)this.deleteResponseWithResponse(responseId, requestOptions).getValue()).toObject(DeleteResponseResponse.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeleteResponseResponse deleteResponse(String responseId) {
        RequestOptions requestOptions = new RequestOptions();
        return (DeleteResponseResponse)((BinaryData)this.deleteResponseWithResponse(responseId, requestOptions).getValue()).toObject(DeleteResponseResponse.class);
    }
}

