/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.implementation;

import com.azure.ai.openai.responses.models.ResponsesStreamEvent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public final class OpenAIServerSentEvents {
    private static final int SSE_CHUNK_LINE_BREAK_COUNT_MARKER = 2;
    private final Flux<ByteBuffer> source;
    private ByteArrayOutputStream outStream;
    private static final ClientLogger LOGGER = new ClientLogger(OpenAIServerSentEvents.class);

    public OpenAIServerSentEvents(Flux<ByteBuffer> source) {
        this.source = source;
        this.outStream = new ByteArrayOutputStream();
    }

    public Flux<ResponsesStreamEvent> getEvents() {
        return this.mapEventStream();
    }

    private Flux<ResponsesStreamEvent> mapEventStream() {
        return this.source.publishOn(Schedulers.boundedElastic()).concatMap(byteBuffer -> {
            ArrayList<ResponsesStreamEvent> values = new ArrayList<ResponsesStreamEvent>();
            byte[] byteArray = byteBuffer.array();
            int lineBreakCharsEncountered = 0;
            try {
                for (byte currentByte : byteArray) {
                    this.outStream.write(currentByte);
                    if (this.isByteLineFeed(currentByte)) {
                        if (++lineBreakCharsEncountered != 2) continue;
                        this.processCurrentEvent(values);
                        this.outStream = new ByteArrayOutputStream();
                        lineBreakCharsEncountered = 0;
                        continue;
                    }
                    if (this.isByteCarriageReturn(currentByte)) continue;
                    lineBreakCharsEncountered = 0;
                }
                this.processRemainingBytes(values);
            }
            catch (IOException e) {
                return Flux.error((Throwable)LOGGER.atError().log((Throwable)e));
            }
            return Flux.fromIterable(values);
        }).cache();
    }

    private void processCurrentEvent(List<ResponsesStreamEvent> values) throws UnsupportedEncodingException {
        String currentLine = this.outStream.toString(StandardCharsets.UTF_8.name());
        this.handleCurrentEvent(currentLine, values);
    }

    private void processRemainingBytes(List<ResponsesStreamEvent> values) throws UnsupportedEncodingException {
        String remainingBytes = this.outStream.toString(StandardCharsets.UTF_8.name());
        if (remainingBytes.endsWith("\n\n")) {
            this.handleCurrentEvent(remainingBytes, values);
        }
    }

    private boolean isByteLineFeed(byte character) {
        return character == 10;
    }

    private boolean isByteCarriageReturn(byte character) {
        return character == 13;
    }

    public void handleCurrentEvent(String currentEvent, List<ResponsesStreamEvent> outputValues) {
        String[] eventLines;
        if (currentEvent.isEmpty()) {
            return;
        }
        for (String event : eventLines = currentEvent.trim().split("\n\n")) {
            String[] lines;
            if (event.isEmpty() || (lines = event.split("\n", 2)).length != 2 || lines[0].isEmpty() || lines[1].isEmpty() || !lines[0].startsWith("event:") || !lines[1].startsWith("data:")) continue;
            String eventJson = lines[1].substring(5).trim();
            outputValues.add((ResponsesStreamEvent)BinaryData.fromString((String)eventJson).toObject(ResponsesStreamEvent.class));
        }
    }
}

