/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesComputerCallItemAction;
import com.azure.ai.openai.responses.models.ResponsesComputerCallItemSafetyCheck;
import com.azure.ai.openai.responses.models.ResponsesComputerCallItemStatus;
import com.azure.ai.openai.responses.models.ResponsesItem;
import com.azure.ai.openai.responses.models.ResponsesItemType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ResponsesComputerCallItem
extends ResponsesItem {
    private ResponsesItemType type = ResponsesItemType.COMPUTER_CALL;
    private final String callId;
    private final ResponsesComputerCallItemAction action;
    private final List<ResponsesComputerCallItemSafetyCheck> pendingSafetyChecks;
    private ResponsesComputerCallItemStatus status;

    public ResponsesComputerCallItem(String callId, ResponsesComputerCallItemAction action, List<ResponsesComputerCallItemSafetyCheck> pendingSafetyChecks) {
        this.callId = callId;
        this.action = action;
        this.pendingSafetyChecks = pendingSafetyChecks;
    }

    @Override
    public ResponsesItemType getType() {
        return this.type;
    }

    public String getCallId() {
        return this.callId;
    }

    public ResponsesComputerCallItemAction getAction() {
        return this.action;
    }

    public List<ResponsesComputerCallItemSafetyCheck> getPendingSafetyChecks() {
        return this.pendingSafetyChecks;
    }

    public ResponsesComputerCallItemStatus getStatus() {
        return this.status;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("call_id", this.callId);
        jsonWriter.writeJsonField("action", (JsonSerializable)this.action);
        jsonWriter.writeArrayField("pending_safety_checks", this.pendingSafetyChecks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesComputerCallItem fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesComputerCallItem)jsonReader.readObject(reader -> {
            String id = null;
            String callId = null;
            ResponsesComputerCallItemAction action = null;
            List pendingSafetyChecks = null;
            ResponsesComputerCallItemStatus status = null;
            ResponsesItemType type = ResponsesItemType.COMPUTER_CALL;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("call_id".equals(fieldName)) {
                    callId = reader.getString();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    action = ResponsesComputerCallItemAction.fromJson(reader);
                    continue;
                }
                if ("pending_safety_checks".equals(fieldName)) {
                    pendingSafetyChecks = reader.readArray(reader1 -> ResponsesComputerCallItemSafetyCheck.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = ResponsesComputerCallItemStatus.fromString(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesItemType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesComputerCallItem deserializedResponsesComputerCallItem = new ResponsesComputerCallItem(callId, action, pendingSafetyChecks);
            deserializedResponsesComputerCallItem.setId(id);
            deserializedResponsesComputerCallItem.status = status;
            deserializedResponsesComputerCallItem.type = type;
            return deserializedResponsesComputerCallItem;
        });
    }
}

