/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesComputerCallActionType;
import com.azure.ai.openai.responses.models.ResponsesComputerCallItemAction;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesComputerCallScrollAction
extends ResponsesComputerCallItemAction {
    private ResponsesComputerCallActionType type = ResponsesComputerCallActionType.SCROLL;
    private final int x;
    private final int y;
    private final int scrollX;
    private final int scrollY;

    public ResponsesComputerCallScrollAction(int x, int y, int scrollX, int scrollY) {
        this.x = x;
        this.y = y;
        this.scrollX = scrollX;
        this.scrollY = scrollY;
    }

    @Override
    public ResponsesComputerCallActionType getType() {
        return this.type;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getScrollX() {
        return this.scrollX;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("x", this.x);
        jsonWriter.writeIntField("y", this.y);
        jsonWriter.writeIntField("scroll_x", this.scrollX);
        jsonWriter.writeIntField("scroll_y", this.scrollY);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesComputerCallScrollAction fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesComputerCallScrollAction)jsonReader.readObject(reader -> {
            int x = 0;
            int y = 0;
            int scrollX = 0;
            int scrollY = 0;
            ResponsesComputerCallActionType type = ResponsesComputerCallActionType.SCROLL;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("x".equals(fieldName)) {
                    x = reader.getInt();
                    continue;
                }
                if ("y".equals(fieldName)) {
                    y = reader.getInt();
                    continue;
                }
                if ("scroll_x".equals(fieldName)) {
                    scrollX = reader.getInt();
                    continue;
                }
                if ("scroll_y".equals(fieldName)) {
                    scrollY = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesComputerCallActionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesComputerCallScrollAction deserializedResponsesComputerCallScrollAction = new ResponsesComputerCallScrollAction(x, y, scrollX, scrollY);
            deserializedResponsesComputerCallScrollAction.type = type;
            return deserializedResponsesComputerCallScrollAction;
        });
    }
}

