/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesFileSearchToolRankingOptions;
import com.azure.ai.openai.responses.models.ResponsesTool;
import com.azure.ai.openai.responses.models.ResponsesToolType;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ResponsesFileSearchTool
extends ResponsesTool {
    private ResponsesToolType type = ResponsesToolType.FILE_SEARCH;
    private final List<String> vectorStoreIds;
    private Integer maxNumResults;
    private ResponsesFileSearchToolRankingOptions rankingOptions;
    private BinaryData filters;

    public ResponsesFileSearchTool(List<String> vectorStoreIds) {
        this.vectorStoreIds = vectorStoreIds;
    }

    @Override
    public ResponsesToolType getType() {
        return this.type;
    }

    public List<String> getVectorStoreIds() {
        return this.vectorStoreIds;
    }

    public Integer getMaxNumResults() {
        return this.maxNumResults;
    }

    public ResponsesFileSearchTool setMaxNumResults(Integer maxNumResults) {
        this.maxNumResults = maxNumResults;
        return this;
    }

    public ResponsesFileSearchToolRankingOptions getRankingOptions() {
        return this.rankingOptions;
    }

    public ResponsesFileSearchTool setRankingOptions(ResponsesFileSearchToolRankingOptions rankingOptions) {
        this.rankingOptions = rankingOptions;
        return this;
    }

    public BinaryData getFilters() {
        return this.filters;
    }

    public ResponsesFileSearchTool setFilters(BinaryData filters) {
        this.filters = filters;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("vector_store_ids", this.vectorStoreIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeNumberField("max_num_results", (Number)this.maxNumResults);
        jsonWriter.writeJsonField("ranking_options", (JsonSerializable)this.rankingOptions);
        if (this.filters != null) {
            jsonWriter.writeFieldName("filters");
            this.filters.writeTo(jsonWriter);
        }
        return jsonWriter.writeEndObject();
    }

    public static ResponsesFileSearchTool fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesFileSearchTool)jsonReader.readObject(reader -> {
            List vectorStoreIds = null;
            ResponsesToolType type = ResponsesToolType.FILE_SEARCH;
            Integer maxNumResults = null;
            ResponsesFileSearchToolRankingOptions rankingOptions = null;
            BinaryData filters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vector_store_ids".equals(fieldName)) {
                    vectorStoreIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesToolType.fromString(reader.getString());
                    continue;
                }
                if ("max_num_results".equals(fieldName)) {
                    maxNumResults = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("ranking_options".equals(fieldName)) {
                    rankingOptions = ResponsesFileSearchToolRankingOptions.fromJson(reader);
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    filters = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesFileSearchTool deserializedResponsesFileSearchTool = new ResponsesFileSearchTool(vectorStoreIds);
            deserializedResponsesFileSearchTool.type = type;
            deserializedResponsesFileSearchTool.maxNumResults = maxNumResults;
            deserializedResponsesFileSearchTool.rankingOptions = rankingOptions;
            deserializedResponsesFileSearchTool.filters = filters;
            return deserializedResponsesFileSearchTool;
        });
    }
}

