/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesTool;
import com.azure.ai.openai.responses.models.ResponsesToolType;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesFunctionTool
extends ResponsesTool {
    private ResponsesToolType type = ResponsesToolType.FUNCTION;
    private final String name;
    private final String description;
    private final BinaryData parameters;
    private final boolean strict;

    public ResponsesFunctionTool(String name, String description, BinaryData parameters, boolean strict) {
        this.name = name;
        this.description = description;
        this.parameters = parameters;
        this.strict = strict;
    }

    @Override
    public ResponsesToolType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public BinaryData getParameters() {
        return this.parameters;
    }

    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeFieldName("parameters");
        this.parameters.writeTo(jsonWriter);
        jsonWriter.writeBooleanField("strict", this.strict);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesFunctionTool fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesFunctionTool)jsonReader.readObject(reader -> {
            String name = null;
            String description = null;
            BinaryData parameters = null;
            boolean strict = false;
            ResponsesToolType type = ResponsesToolType.FUNCTION;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    parameters = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("strict".equals(fieldName)) {
                    strict = reader.getBoolean();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesToolType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesFunctionTool deserializedResponsesFunctionTool = new ResponsesFunctionTool(name, description, parameters, strict);
            deserializedResponsesFunctionTool.type = type;
            return deserializedResponsesFunctionTool;
        });
    }
}

