/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesResponse;
import com.azure.ai.openai.responses.models.ResponsesStreamEvent;
import com.azure.ai.openai.responses.models.ResponsesStreamEventType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesStreamEventCompleted
extends ResponsesStreamEvent {
    private ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_COMPLETED;
    private final ResponsesResponse response;

    private ResponsesStreamEventCompleted(ResponsesResponse response) {
        this.response = response;
    }

    @Override
    public ResponsesStreamEventType getType() {
        return this.type;
    }

    public ResponsesResponse getResponse() {
        return this.response;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("response", (JsonSerializable)this.response);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesStreamEventCompleted fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesStreamEventCompleted)jsonReader.readObject(reader -> {
            ResponsesResponse response = null;
            ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_COMPLETED;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("response".equals(fieldName)) {
                    response = ResponsesResponse.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesStreamEventType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesStreamEventCompleted deserializedResponsesStreamEventCompleted = new ResponsesStreamEventCompleted(response);
            deserializedResponsesStreamEventCompleted.type = type;
            return deserializedResponsesStreamEventCompleted;
        });
    }
}

