/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesResponse;
import com.azure.ai.openai.responses.models.ResponsesStreamEvent;
import com.azure.ai.openai.responses.models.ResponsesStreamEventType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesStreamEventInProgress
extends ResponsesStreamEvent {
    private ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_IN_PROGRESS;
    private final ResponsesResponse response;

    private ResponsesStreamEventInProgress(ResponsesResponse response) {
        this.response = response;
    }

    @Override
    public ResponsesStreamEventType getType() {
        return this.type;
    }

    public ResponsesResponse getResponse() {
        return this.response;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("response", (JsonSerializable)this.response);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesStreamEventInProgress fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesStreamEventInProgress)jsonReader.readObject(reader -> {
            ResponsesResponse response = null;
            ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_IN_PROGRESS;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("response".equals(fieldName)) {
                    response = ResponsesResponse.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesStreamEventType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesStreamEventInProgress deserializedResponsesStreamEventInProgress = new ResponsesStreamEventInProgress(response);
            deserializedResponsesStreamEventInProgress.type = type;
            return deserializedResponsesStreamEventInProgress;
        });
    }
}

