/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesResponse;
import com.azure.ai.openai.responses.models.ResponsesStreamEvent;
import com.azure.ai.openai.responses.models.ResponsesStreamEventType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesStreamEventIncomplete
extends ResponsesStreamEvent {
    private ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_INCOMPLETE;
    private final ResponsesResponse response;

    private ResponsesStreamEventIncomplete(ResponsesResponse response) {
        this.response = response;
    }

    @Override
    public ResponsesStreamEventType getType() {
        return this.type;
    }

    public ResponsesResponse getResponse() {
        return this.response;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("response", (JsonSerializable)this.response);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesStreamEventIncomplete fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesStreamEventIncomplete)jsonReader.readObject(reader -> {
            ResponsesResponse response = null;
            ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_INCOMPLETE;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("response".equals(fieldName)) {
                    response = ResponsesResponse.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesStreamEventType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesStreamEventIncomplete deserializedResponsesStreamEventIncomplete = new ResponsesStreamEventIncomplete(response);
            deserializedResponsesStreamEventIncomplete.type = type;
            return deserializedResponsesStreamEventIncomplete;
        });
    }
}

