/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesContent;
import com.azure.ai.openai.responses.models.ResponsesItemType;
import com.azure.ai.openai.responses.models.ResponsesMessage;
import com.azure.ai.openai.responses.models.ResponsesMessageRole;
import com.azure.ai.openai.responses.models.ResponsesMessageStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ResponsesUserMessage
extends ResponsesMessage {
    private ResponsesItemType type = ResponsesItemType.MESSAGE;
    private ResponsesMessageRole role = ResponsesMessageRole.USER;
    private final List<ResponsesContent> content;

    public ResponsesUserMessage(List<ResponsesContent> content) {
        this.content = content;
    }

    @Override
    public ResponsesItemType getType() {
        return this.type;
    }

    @Override
    public ResponsesMessageRole getRole() {
        return this.role;
    }

    public List<ResponsesContent> getContent() {
        return this.content;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("content", this.content, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesUserMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesUserMessage)jsonReader.readObject(reader -> {
            String id = null;
            ResponsesMessageStatus status = null;
            List content = null;
            ResponsesMessageRole role = ResponsesMessageRole.USER;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = ResponsesMessageStatus.fromString(reader.getString());
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = reader.readArray(reader1 -> ResponsesContent.fromJson(reader1));
                    continue;
                }
                if ("role".equals(fieldName)) {
                    role = ResponsesMessageRole.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesUserMessage deserializedResponsesUserMessage = new ResponsesUserMessage(content);
            deserializedResponsesUserMessage.setId(id);
            deserializedResponsesUserMessage.setStatus(status);
            deserializedResponsesUserMessage.role = role;
            return deserializedResponsesUserMessage;
        });
    }
}

