// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

/**
 * Extended information about a single segment of translated audio data.
 * Segments generally represent roughly 5-10 seconds of speech. Segment boundaries typically occur between words but not
 * necessarily sentences.
 */
@Immutable
public final class AudioTranslationSegment implements JsonSerializable<AudioTranslationSegment> {

    /*
     * The 0-based index of this segment within a translation.
     */
    @Generated
    private final int id;

    /*
     * The time at which this segment started relative to the beginning of the translated audio.
     */
    @Generated
    private final double start;

    /*
     * The time at which this segment ended relative to the beginning of the translated audio.
     */
    @Generated
    private final double end;

    /*
     * The translated text that was part of this audio segment.
     */
    @Generated
    private final String text;

    /*
     * The temperature score associated with this audio segment.
     */
    @Generated
    private final double temperature;

    /*
     * The average log probability associated with this audio segment.
     */
    @Generated
    private final double avgLogprob;

    /*
     * The compression ratio of this audio segment.
     */
    @Generated
    private final double compressionRatio;

    /*
     * The probability of no speech detection within this audio segment.
     */
    @Generated
    private final double noSpeechProb;

    /*
     * The token IDs matching the translated text in this audio segment.
     */
    @Generated
    private final List<Integer> tokens;

    /*
     * The seek position associated with the processing of this audio segment.
     * Seek positions are expressed as hundredths of seconds.
     * The model may process several segments from a single seek position, so while the seek position will never
     * represent
     * a later time than the segment's start, the segment's start may represent a significantly later time than the
     * segment's associated seek position.
     */
    @Generated
    private final int seek;

    /**
     * Creates an instance of AudioTranslationSegment class.
     *
     * @param id the id value to set.
     * @param start the start value to set.
     * @param end the end value to set.
     * @param text the text value to set.
     * @param temperature the temperature value to set.
     * @param avgLogprob the avgLogprob value to set.
     * @param compressionRatio the compressionRatio value to set.
     * @param noSpeechProb the noSpeechProb value to set.
     * @param tokens the tokens value to set.
     * @param seek the seek value to set.
     */
    @Generated
    private AudioTranslationSegment(int id, Duration start, Duration end, String text, double temperature,
        double avgLogprob, double compressionRatio, double noSpeechProb, List<Integer> tokens, int seek) {
        this.id = id;
        if (start == null) {
            this.start = 0.0;
        } else {
            this.start = (double) start.toNanos() / 1000_000_000L;
        }
        if (end == null) {
            this.end = 0.0;
        } else {
            this.end = (double) end.toNanos() / 1000_000_000L;
        }
        this.text = text;
        this.temperature = temperature;
        this.avgLogprob = avgLogprob;
        this.compressionRatio = compressionRatio;
        this.noSpeechProb = noSpeechProb;
        this.tokens = tokens;
        this.seek = seek;
    }

    /**
     * Get the id property: The 0-based index of this segment within a translation.
     *
     * @return the id value.
     */
    @Generated
    public int getId() {
        return this.id;
    }

    /**
     * Get the start property: The time at which this segment started relative to the beginning of the translated audio.
     *
     * @return the start value.
     */
    @Generated
    public Duration getStart() {
        return Duration.ofNanos((long) (this.start * 1000_000_000L));
    }

    /**
     * Get the end property: The time at which this segment ended relative to the beginning of the translated audio.
     *
     * @return the end value.
     */
    @Generated
    public Duration getEnd() {
        return Duration.ofNanos((long) (this.end * 1000_000_000L));
    }

    /**
     * Get the text property: The translated text that was part of this audio segment.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * Get the temperature property: The temperature score associated with this audio segment.
     *
     * @return the temperature value.
     */
    @Generated
    public double getTemperature() {
        return this.temperature;
    }

    /**
     * Get the avgLogprob property: The average log probability associated with this audio segment.
     *
     * @return the avgLogprob value.
     */
    @Generated
    public double getAvgLogprob() {
        return this.avgLogprob;
    }

    /**
     * Get the compressionRatio property: The compression ratio of this audio segment.
     *
     * @return the compressionRatio value.
     */
    @Generated
    public double getCompressionRatio() {
        return this.compressionRatio;
    }

    /**
     * Get the noSpeechProb property: The probability of no speech detection within this audio segment.
     *
     * @return the noSpeechProb value.
     */
    @Generated
    public double getNoSpeechProb() {
        return this.noSpeechProb;
    }

    /**
     * Get the tokens property: The token IDs matching the translated text in this audio segment.
     *
     * @return the tokens value.
     */
    @Generated
    public List<Integer> getTokens() {
        return this.tokens;
    }

    /**
     * Get the seek property: The seek position associated with the processing of this audio segment.
     * Seek positions are expressed as hundredths of seconds.
     * The model may process several segments from a single seek position, so while the seek position will never
     * represent
     * a later time than the segment's start, the segment's start may represent a significantly later time than the
     * segment's associated seek position.
     *
     * @return the seek value.
     */
    @Generated
    public int getSeek() {
        return this.seek;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", this.id);
        jsonWriter.writeDoubleField("start", this.start);
        jsonWriter.writeDoubleField("end", this.end);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeDoubleField("temperature", this.temperature);
        jsonWriter.writeDoubleField("avg_logprob", this.avgLogprob);
        jsonWriter.writeDoubleField("compression_ratio", this.compressionRatio);
        jsonWriter.writeDoubleField("no_speech_prob", this.noSpeechProb);
        jsonWriter.writeArrayField("tokens", this.tokens, (writer, element) -> writer.writeInt(element));
        jsonWriter.writeIntField("seek", this.seek);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AudioTranslationSegment from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AudioTranslationSegment if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AudioTranslationSegment.
     */
    @Generated
    public static AudioTranslationSegment fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int id = 0;
            Duration start = null;
            Duration end = null;
            String text = null;
            double temperature = 0.0;
            double avgLogprob = 0.0;
            double compressionRatio = 0.0;
            double noSpeechProb = 0.0;
            List<Integer> tokens = null;
            int seek = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                } else if ("start".equals(fieldName)) {
                    start = Duration.ofNanos((long) (reader.getDouble() * 1000_000_000L));
                } else if ("end".equals(fieldName)) {
                    end = Duration.ofNanos((long) (reader.getDouble() * 1000_000_000L));
                } else if ("text".equals(fieldName)) {
                    text = reader.getString();
                } else if ("temperature".equals(fieldName)) {
                    temperature = reader.getDouble();
                } else if ("avg_logprob".equals(fieldName)) {
                    avgLogprob = reader.getDouble();
                } else if ("compression_ratio".equals(fieldName)) {
                    compressionRatio = reader.getDouble();
                } else if ("no_speech_prob".equals(fieldName)) {
                    noSpeechProb = reader.getDouble();
                } else if ("tokens".equals(fieldName)) {
                    tokens = reader.readArray(reader1 -> reader1.getInt());
                } else if ("seek".equals(fieldName)) {
                    seek = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }
            return new AudioTranslationSegment(id, start, end, text, temperature, avgLogprob, compressionRatio,
                noSpeechProb, tokens, seek);
        });
    }
}
