// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A representation of the available options for the Azure OpenAI grounding enhancement.
 */
@Immutable
public final class AzureChatGroundingEnhancementConfiguration
    implements JsonSerializable<AzureChatGroundingEnhancementConfiguration> {

    /*
     * Specifies whether the enhancement is enabled.
     */
    @Generated
    private final boolean enabled;

    /**
     * Creates an instance of AzureChatGroundingEnhancementConfiguration class.
     *
     * @param enabled the enabled value to set.
     */
    @Generated
    public AzureChatGroundingEnhancementConfiguration(boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * Get the enabled property: Specifies whether the enhancement is enabled.
     *
     * @return the enabled value.
     */
    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureChatGroundingEnhancementConfiguration from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureChatGroundingEnhancementConfiguration if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureChatGroundingEnhancementConfiguration.
     */
    @Generated
    public static AzureChatGroundingEnhancementConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean enabled = false;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    enabled = reader.getBoolean();
                } else {
                    reader.skipChildren();
                }
            }
            return new AzureChatGroundingEnhancementConfiguration(enabled);
        });
    }
}
