// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A response format for Chat Completions that restricts responses to emitting JSON that conforms to a provided JSON
 * Schema for Structured Outputs.
 */
@Immutable
public final class ChatCompletionsJsonSchemaResponseFormat extends ChatCompletionsResponseFormat {

    /*
     * The discriminated type for the response format.
     */
    @Generated
    private String type = "json_schema";

    /*
     * The json_schema property.
     */
    @Generated
    private final ChatCompletionsJsonSchemaResponseFormatJsonSchema jsonSchema;

    /**
     * Creates an instance of ChatCompletionsJsonSchemaResponseFormat class.
     *
     * @param jsonSchema the jsonSchema value to set.
     */
    @Generated
    public ChatCompletionsJsonSchemaResponseFormat(ChatCompletionsJsonSchemaResponseFormatJsonSchema jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    /**
     * Get the type property: The discriminated type for the response format.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the jsonSchema property: The json_schema property.
     *
     * @return the jsonSchema value.
     */
    @Generated
    public ChatCompletionsJsonSchemaResponseFormatJsonSchema getJsonSchema() {
        return this.jsonSchema;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("json_schema", this.jsonSchema);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionsJsonSchemaResponseFormat from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionsJsonSchemaResponseFormat if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatCompletionsJsonSchemaResponseFormat.
     */
    @Generated
    public static ChatCompletionsJsonSchemaResponseFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatCompletionsJsonSchemaResponseFormatJsonSchema jsonSchema = null;
            String type = "json_schema";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("json_schema".equals(fieldName)) {
                    jsonSchema = ChatCompletionsJsonSchemaResponseFormatJsonSchema.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            ChatCompletionsJsonSchemaResponseFormat deserializedChatCompletionsJsonSchemaResponseFormat
                = new ChatCompletionsJsonSchemaResponseFormat(jsonSchema);
            deserializedChatCompletionsJsonSchemaResponseFormat.type = type;
            return deserializedChatCompletionsJsonSchemaResponseFormat;
        });
    }
}
