// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ChatCompletionsJsonSchemaResponseFormatJsonSchema model.
 */
@Fluent
public final class ChatCompletionsJsonSchemaResponseFormatJsonSchema
    implements JsonSerializable<ChatCompletionsJsonSchemaResponseFormatJsonSchema> {

    /*
     * A description of what the response format is for, used by the model to determine how to respond in the format.
     */
    @Generated
    private String description;

    /*
     * The name of the response format. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length
     * of 64.
     */
    @Generated
    private final String name;

    /*
     * The schema property.
     */
    private BinaryData schema;

    /*
     * Whether to enable strict schema adherence when generating the output. If set to true, the model will always
     * follow the exact schema defined in the `schema` field. Only a subset of JSON Schema is supported when `strict` is
     * `true`. To learn more, read the [Structured Outputs guide](/docs/guides/structured-outputs).
     */
    @Generated
    private Boolean strict;

    /**
     * Creates an instance of ChatCompletionsJsonSchemaResponseFormatJsonSchema class.
     *
     * @param name the name value to set.
     */
    @Generated
    public ChatCompletionsJsonSchemaResponseFormatJsonSchema(String name) {
        this.name = name;
    }

    /**
     * Get the description property: A description of what the response format is for, used by the model to determine
     * how to respond in the format.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: A description of what the response format is for, used by the model to determine
     * how to respond in the format.
     *
     * @param description the description value to set.
     * @return the ChatCompletionsJsonSchemaResponseFormatJsonSchema object itself.
     */
    @Generated
    public ChatCompletionsJsonSchemaResponseFormatJsonSchema setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the name property: The name of the response format. Must be a-z, A-Z, 0-9, or contain underscores and dashes,
     * with a maximum length of 64.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the schema property: The schema property.
     *
     * @return the schema value.
     */
    public BinaryData getSchema() {
        return this.schema;
    }

    /**
     * Set the schema property: The schema property.
     *
     * @param schema the schema value to set.
     * @return the ChatCompletionsJsonSchemaResponseFormatJsonSchema object itself.
     */
    public ChatCompletionsJsonSchemaResponseFormatJsonSchema setSchema(BinaryData schema) {
        this.schema = schema;
        return this;
    }

    /**
     * Get the strict property: Whether to enable strict schema adherence when generating the output. If set to true,
     * the model will always follow the exact schema defined in the `schema` field. Only a subset of JSON Schema is
     * supported when `strict` is `true`. To learn more, read the [Structured Outputs
     * guide](/docs/guides/structured-outputs).
     *
     * @return the strict value.
     */
    @Generated
    public Boolean isStrict() {
        return this.strict;
    }

    /**
     * Set the strict property: Whether to enable strict schema adherence when generating the output. If set to true,
     * the model will always follow the exact schema defined in the `schema` field. Only a subset of JSON Schema is
     * supported when `strict` is `true`. To learn more, read the [Structured Outputs
     * guide](/docs/guides/structured-outputs).
     *
     * @param strict the strict value to set.
     * @return the ChatCompletionsJsonSchemaResponseFormatJsonSchema object itself.
     */
    @Generated
    public ChatCompletionsJsonSchemaResponseFormatJsonSchema setStrict(Boolean strict) {
        this.strict = strict;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeRawField("schema", this.schema.toString());
        jsonWriter.writeBooleanField("strict", this.strict);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionsJsonSchemaResponseFormatJsonSchema from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionsJsonSchemaResponseFormatJsonSchema if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatCompletionsJsonSchemaResponseFormatJsonSchema.
     */
    public static ChatCompletionsJsonSchemaResponseFormatJsonSchema fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String name = null;
            String description = null;
            BinaryData schema = null;
            Boolean strict = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("schema".equals(fieldName)) {
                    schema = BinaryData.fromObject(reader.readUntyped());
                } else if ("strict".equals(fieldName)) {
                    strict = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }
            ChatCompletionsJsonSchemaResponseFormatJsonSchema deserializedChatCompletionsJsonSchemaResponseFormatJsonSchema
                = new ChatCompletionsJsonSchemaResponseFormatJsonSchema(name);
            deserializedChatCompletionsJsonSchemaResponseFormatJsonSchema.description = description;
            deserializedChatCompletionsJsonSchemaResponseFormatJsonSchema.schema = schema;
            deserializedChatCompletionsJsonSchemaResponseFormatJsonSchema.strict = strict;
            return deserializedChatCompletionsJsonSchemaResponseFormatJsonSchema;
        });
    }
}
