// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Base64;

/**
 * A structured chat content item containing audio data.
 */
@Immutable
public final class InputAudioContent implements JsonSerializable<InputAudioContent> {

    /*
     * Base64-encoded audio data.
     */
    @Generated
    private final String data;

    /*
     * The format of the audio data.
     */
    @Generated
    private final InputAudioFormat format;

    /**
     * Creates an instance of InputAudioContent class.
     *
     * @param data the data value to set.
     * @param format the format value to set.
     */
    @Generated
    public InputAudioContent(String data, InputAudioFormat format) {
        this.data = data;
        this.format = format;
    }

    /**
     * Creates an instance of InputAudioContent class.
     *
     * @param data - the audio data to set.
     * @param format - the format to set.
     */
    public InputAudioContent(byte[] data, InputAudioFormat format) {
        this.data = Base64.getEncoder().encodeToString(data);
        this.format = format;
    }

    /**
     * Get the data property: Base64-encoded audio data.
     *
     * @return the data value.
     */
    @Generated
    public String getData() {
        return this.data;
    }

    /**
     * Get the format property: The format of the audio data.
     *
     * @return the format value.
     */
    @Generated
    public InputAudioFormat getFormat() {
        return this.format;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("data", this.data);
        jsonWriter.writeStringField("format", this.format == null ? null : this.format.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InputAudioContent from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of InputAudioContent if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the InputAudioContent.
     */
    @Generated
    public static InputAudioContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String data = null;
            InputAudioFormat format = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("data".equals(fieldName)) {
                    data = reader.getString();
                } else if ("format".equals(fieldName)) {
                    format = InputAudioFormat.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return new InputAudioContent(data, format);
        });
    }
}
