// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.openai.responses.models;

/**
 * Defines values for CreateResponseRequestAccept.
 */
public enum CreateResponseRequestAccept {
    /**
     * Enum value application/json.
     */
    APPLICATION_JSON("application/json"),

    /**
     * Enum value text/event-stream.
     */
    TEXT_EVENT_STREAM("text/event-stream");

    /**
     * The actual serialized value for a CreateResponseRequestAccept instance.
     */
    private final String value;

    CreateResponseRequestAccept(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a CreateResponseRequestAccept instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed CreateResponseRequestAccept object, or null if unable to parse.
     */
    public static CreateResponseRequestAccept fromString(String value) {
        if (value == null) {
            return null;
        }
        CreateResponseRequestAccept[] items = CreateResponseRequestAccept.values();
        for (CreateResponseRequestAccept item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
