// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.openai.responses.models;

/**
 * Defines values for CreateResponsesRequestIncludable.
 */
public enum CreateResponsesRequestIncludable {
    /**
     * Enum value file_search_call.results.
     */
    FILE_SEARCH_CALL_RESULTS("file_search_call.results"),

    /**
     * Enum value computer_call_output.output.image_url.
     */
    COMPUTER_CALL_OUTPUT_OUTPUT_IMAGE_URL("computer_call_output.output.image_url"),

    /**
     * Enum value message.input_image.image_url.
     */
    MESSAGE_INPUT_IMAGE_IMAGE_URL("message.input_image.image_url");

    /**
     * The actual serialized value for a CreateResponsesRequestIncludable instance.
     */
    private final String value;

    CreateResponsesRequestIncludable(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a CreateResponsesRequestIncludable instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed CreateResponsesRequestIncludable object, or null if unable to parse.
     */
    public static CreateResponsesRequestIncludable fromString(String value) {
        if (value == null) {
            return null;
        }
        CreateResponsesRequestIncludable[] items = CreateResponsesRequestIncludable.values();
        for (CreateResponsesRequestIncludable item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
