// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The DeleteResponseResponse model.
 */
@Immutable
public final class DeleteResponseResponse implements JsonSerializable<DeleteResponseResponse> {

    /*
     * The object property.
     */
    @Generated
    private final String object = "response.deleted";

    /*
     * The id property.
     */
    @Generated
    private final String id;

    /*
     * The deleted property.
     */
    @Generated
    private final boolean deleted = true;

    /**
     * Creates an instance of DeleteResponseResponse class.
     *
     * @param id the id value to set.
     */
    @Generated
    private DeleteResponseResponse(String id) {
        this.id = id;
    }

    /**
     * Get the object property: The object property.
     *
     * @return the object value.
     */
    @Generated
    public String getObject() {
        return this.object;
    }

    /**
     * Get the id property: The id property.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the deleted property: The deleted property.
     *
     * @return the deleted value.
     */
    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeBooleanField("deleted", this.deleted);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeleteResponseResponse from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeleteResponseResponse if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DeleteResponseResponse.
     */
    @Generated
    public static DeleteResponseResponse fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return new DeleteResponseResponse(id);
        });
    }
}
