// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ResponsesComputerCallOutputItemScreenshot model.
 */
@Fluent
public final class ResponsesComputerCallOutputItemScreenshot extends ResponsesComputerCallOutputItemOutput {

    /*
     * The type property.
     */
    @Generated
    private ResponsesComputerCallOutputItemOutputType type
        = ResponsesComputerCallOutputItemOutputType.COMPUTER_SCREENSHOT;

    /*
     * The image_url property.
     */
    @Generated
    private String imageUrl;

    /*
     * The file_id property.
     */
    @Generated
    private String fileId;

    /**
     * Creates an instance of ResponsesComputerCallOutputItemScreenshot class.
     */
    @Generated
    public ResponsesComputerCallOutputItemScreenshot() {
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public ResponsesComputerCallOutputItemOutputType getType() {
        return this.type;
    }

    /**
     * Get the imageUrl property: The image_url property.
     *
     * @return the imageUrl value.
     */
    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    /**
     * Set the imageUrl property: The image_url property.
     *
     * @param imageUrl the imageUrl value to set.
     * @return the ResponsesComputerCallOutputItemScreenshot object itself.
     */
    @Generated
    public ResponsesComputerCallOutputItemScreenshot setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    /**
     * Get the fileId property: The file_id property.
     *
     * @return the fileId value.
     */
    @Generated
    public String getFileId() {
        return this.fileId;
    }

    /**
     * Set the fileId property: The file_id property.
     *
     * @param fileId the fileId value to set.
     * @return the ResponsesComputerCallOutputItemScreenshot object itself.
     */
    @Generated
    public ResponsesComputerCallOutputItemScreenshot setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("image_url", this.imageUrl);
        jsonWriter.writeStringField("file_id", this.fileId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesComputerCallOutputItemScreenshot from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesComputerCallOutputItemScreenshot if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResponsesComputerCallOutputItemScreenshot.
     */
    @Generated
    public static ResponsesComputerCallOutputItemScreenshot fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResponsesComputerCallOutputItemScreenshot deserializedResponsesComputerCallOutputItemScreenshot
                = new ResponsesComputerCallOutputItemScreenshot();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedResponsesComputerCallOutputItemScreenshot.type
                        = ResponsesComputerCallOutputItemOutputType.fromString(reader.getString());
                } else if ("image_url".equals(fieldName)) {
                    deserializedResponsesComputerCallOutputItemScreenshot.imageUrl = reader.getString();
                } else if ("file_id".equals(fieldName)) {
                    deserializedResponsesComputerCallOutputItemScreenshot.fileId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedResponsesComputerCallOutputItemScreenshot;
        });
    }
}
