// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ResponsesComputerTool model.
 */
@Immutable
public final class ResponsesComputerTool extends ResponsesTool {

    /*
     * The type property.
     */
    @Generated
    private ResponsesToolType type = ResponsesToolType.COMPUTER;

    /*
     * The display_width property.
     */
    @Generated
    private final int displayWidth;

    /*
     * The display_height property.
     */
    @Generated
    private final int displayHeight;

    /*
     * The environment property.
     */
    @Generated
    private final ResponsesComputerToolEnvironment environment;

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public ResponsesToolType getType() {
        return this.type;
    }

    /**
     * Get the displayWidth property: The display_width property.
     *
     * @return the displayWidth value.
     */
    @Generated
    public int getDisplayWidth() {
        return this.displayWidth;
    }

    /**
     * Get the displayHeight property: The display_height property.
     *
     * @return the displayHeight value.
     */
    @Generated
    public int getDisplayHeight() {
        return this.displayHeight;
    }

    /**
     * Get the environment property: The environment property.
     *
     * @return the environment value.
     */
    @Generated
    public ResponsesComputerToolEnvironment getEnvironment() {
        return this.environment;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("display_width", this.displayWidth);
        jsonWriter.writeIntField("display_height", this.displayHeight);
        jsonWriter.writeStringField("environment", this.environment == null ? null : this.environment.toString());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesComputerTool from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesComputerTool if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponsesComputerTool.
     */
    @Generated
    public static ResponsesComputerTool fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int displayWidth = 0;
            int displayHeight = 0;
            ResponsesComputerToolEnvironment environment = null;
            ResponsesToolType type = ResponsesToolType.COMPUTER;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("display_width".equals(fieldName)) {
                    displayWidth = reader.getInt();
                } else if ("display_height".equals(fieldName)) {
                    displayHeight = reader.getInt();
                } else if ("environment".equals(fieldName)) {
                    environment = ResponsesComputerToolEnvironment.fromString(reader.getString());
                } else if ("type".equals(fieldName)) {
                    type = ResponsesToolType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ResponsesComputerTool deserializedResponsesComputerTool
                = new ResponsesComputerTool(displayWidth, displayHeight, environment);
            deserializedResponsesComputerTool.type = type;
            return deserializedResponsesComputerTool;
        });
    }

    /**
     * Creates an instance of ResponsesComputerTool class.
     *
     * @param displayWidth the displayWidth value to set.
     * @param displayHeight the displayHeight value to set.
     * @param environment the environment value to set.
     */
    @Generated
    public ResponsesComputerTool(int displayWidth, int displayHeight, ResponsesComputerToolEnvironment environment) {
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
        this.environment = environment;
    }
}
