// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.openai.responses.models;

/**
 * Defines values for ResponsesComputerToolEnvironment.
 */
public enum ResponsesComputerToolEnvironment {
    /**
     * Enum value windows.
     */
    WINDOWS("windows"),

    /**
     * Enum value mac.
     */
    MAC("mac"),

    /**
     * Enum value ubuntu.
     */
    UBUNTU("ubuntu"),

    /**
     * Enum value browser.
     */
    BROWSER("browser");

    /**
     * The actual serialized value for a ResponsesComputerToolEnvironment instance.
     */
    private final String value;

    ResponsesComputerToolEnvironment(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ResponsesComputerToolEnvironment instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ResponsesComputerToolEnvironment object, or null if unable to parse.
     */
    public static ResponsesComputerToolEnvironment fromString(String value) {
        if (value == null) {
            return null;
        }
        ResponsesComputerToolEnvironment[] items = ResponsesComputerToolEnvironment.values();
        for (ResponsesComputerToolEnvironment item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
