// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The ResponsesFileSearchCallItem model.
 */
@Immutable
public final class ResponsesFileSearchCallItem extends ResponsesItem {

    /*
     * The type property.
     */
    @Generated
    private ResponsesItemType type = ResponsesItemType.FILE_SEARCH_CALL;

    /*
     * The status property.
     */
    @Generated
    private ResponsesFileSearchCallItemStatus status;

    /*
     * The queries property.
     */
    @Generated
    private final List<String> queries;

    /*
     * The results property.
     */
    @Generated
    private final List<ResponsesFileSearchCallItemResult> results;

    /**
     * Creates an instance of ResponsesFileSearchCallItem class.
     *
     * @param queries the queries value to set.
     * @param results the results value to set.
     */
    @Generated
    public ResponsesFileSearchCallItem(List<String> queries, List<ResponsesFileSearchCallItemResult> results) {
        this.queries = queries;
        this.results = results;
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public ResponsesItemType getType() {
        return this.type;
    }

    /**
     * Get the status property: The status property.
     *
     * @return the status value.
     */
    @Generated
    public ResponsesFileSearchCallItemStatus getStatus() {
        return this.status;
    }

    /**
     * Get the queries property: The queries property.
     *
     * @return the queries value.
     */
    @Generated
    public List<String> getQueries() {
        return this.queries;
    }

    /**
     * Get the results property: The results property.
     *
     * @return the results value.
     */
    @Generated
    public List<ResponsesFileSearchCallItemResult> getResults() {
        return this.results;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("queries", this.queries, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("results", this.results, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesFileSearchCallItem from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesFileSearchCallItem if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponsesFileSearchCallItem.
     */
    @Generated
    public static ResponsesFileSearchCallItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            ResponsesFileSearchCallItemStatus status = null;
            List<String> queries = null;
            List<ResponsesFileSearchCallItemResult> results = null;
            ResponsesItemType type = ResponsesItemType.FILE_SEARCH_CALL;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("status".equals(fieldName)) {
                    status = ResponsesFileSearchCallItemStatus.fromString(reader.getString());
                } else if ("queries".equals(fieldName)) {
                    queries = reader.readArray(reader1 -> reader1.getString());
                } else if ("results".equals(fieldName)) {
                    results = reader.readArray(reader1 -> ResponsesFileSearchCallItemResult.fromJson(reader1));
                } else if ("type".equals(fieldName)) {
                    type = ResponsesItemType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ResponsesFileSearchCallItem deserializedResponsesFileSearchCallItem
                = new ResponsesFileSearchCallItem(queries, results);
            deserializedResponsesFileSearchCallItem.setId(id);
            deserializedResponsesFileSearchCallItem.status = status;
            deserializedResponsesFileSearchCallItem.type = type;
            return deserializedResponsesFileSearchCallItem;
        });
    }
}
