// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ResponsesFunctionCallItem model.
 */
@Immutable
public final class ResponsesFunctionCallItem extends ResponsesItem {

    /*
     * The type property.
     */
    @Generated
    private ResponsesItemType type = ResponsesItemType.FUNCTION_CALL;

    /*
     * The status property.
     */
    @Generated
    private ResponsesFunctionCallItemStatus status;

    /*
     * The call_id property.
     */
    @Generated
    private final String callId;

    /*
     * The name property.
     */
    @Generated
    private final String name;

    /*
     * The arguments property.
     */
    @Generated
    private final String arguments;

    /**
     * Creates an instance of ResponsesFunctionCallItem class.
     *
     * @param callId the callId value to set.
     * @param name the name value to set.
     * @param arguments the arguments value to set.
     */
    @Generated
    public ResponsesFunctionCallItem(String callId, String name, String arguments) {
        this.callId = callId;
        this.name = name;
        this.arguments = arguments;
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public ResponsesItemType getType() {
        return this.type;
    }

    /**
     * Get the status property: The status property.
     *
     * @return the status value.
     */
    @Generated
    public ResponsesFunctionCallItemStatus getStatus() {
        return this.status;
    }

    /**
     * Get the callId property: The call_id property.
     *
     * @return the callId value.
     */
    @Generated
    public String getCallId() {
        return this.callId;
    }

    /**
     * Get the name property: The name property.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the arguments property: The arguments property.
     *
     * @return the arguments value.
     */
    @Generated
    public String getArguments() {
        return this.arguments;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("call_id", this.callId);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("arguments", this.arguments);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesFunctionCallItem from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesFunctionCallItem if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponsesFunctionCallItem.
     */
    @Generated
    public static ResponsesFunctionCallItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            String callId = null;
            String name = null;
            String arguments = null;
            ResponsesItemType type = ResponsesItemType.FUNCTION_CALL;
            ResponsesFunctionCallItemStatus status = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("call_id".equals(fieldName)) {
                    callId = reader.getString();
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("arguments".equals(fieldName)) {
                    arguments = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = ResponsesItemType.fromString(reader.getString());
                } else if ("status".equals(fieldName)) {
                    status = ResponsesFunctionCallItemStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ResponsesFunctionCallItem deserializedResponsesFunctionCallItem
                = new ResponsesFunctionCallItem(callId, name, arguments);
            deserializedResponsesFunctionCallItem.setId(id);
            deserializedResponsesFunctionCallItem.type = type;
            deserializedResponsesFunctionCallItem.status = status;
            return deserializedResponsesFunctionCallItem;
        });
    }
}
