// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.openai.responses.models;

/**
 * Defines values for ResponsesFunctionCallOutputStatus.
 */
public enum ResponsesFunctionCallOutputStatus {
    /**
     * Enum value in_progress.
     */
    IN_PROGRESS("in_progress"),

    /**
     * Enum value completed.
     */
    COMPLETED("completed"),

    /**
     * Enum value incomplete.
     */
    INCOMPLETE("incomplete");

    /**
     * The actual serialized value for a ResponsesFunctionCallOutputStatus instance.
     */
    private final String value;

    ResponsesFunctionCallOutputStatus(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ResponsesFunctionCallOutputStatus instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ResponsesFunctionCallOutputStatus object, or null if unable to parse.
     */
    public static ResponsesFunctionCallOutputStatus fromString(String value) {
        if (value == null) {
            return null;
        }
        ResponsesFunctionCallOutputStatus[] items = ResponsesFunctionCallOutputStatus.values();
        for (ResponsesFunctionCallOutputStatus item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
