// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.openai.responses.models;

/**
 * Defines values for ResponsesInputContentImageDetail.
 */
public enum ResponsesInputContentImageDetail {
    /**
     * Enum value low.
     */
    LOW("low"),

    /**
     * Enum value high.
     */
    HIGH("high"),

    /**
     * Enum value auto.
     */
    AUTO("auto");

    /**
     * The actual serialized value for a ResponsesInputContentImageDetail instance.
     */
    private final String value;

    ResponsesInputContentImageDetail(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ResponsesInputContentImageDetail instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ResponsesInputContentImageDetail object, or null if unable to parse.
     */
    public static ResponsesInputContentImageDetail fromString(String value) {
        if (value == null) {
            return null;
        }
        ResponsesInputContentImageDetail[] items = ResponsesInputContentImageDetail.values();
        for (ResponsesInputContentImageDetail item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
