// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ResponsesOutputTextAnnotationFileCitation model.
 */
@Immutable
public final class ResponsesOutputTextAnnotationFileCitation extends ResponsesOutputTextAnnotation {

    /*
     * The type property.
     */
    @Generated
    private ResponseOutputTextAnnotationType type = ResponseOutputTextAnnotationType.FILE_CITATION;

    /*
     * The index property.
     */
    @Generated
    private final int index;

    /*
     * The file_id property.
     */
    @Generated
    private final String fileId;

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public ResponseOutputTextAnnotationType getType() {
        return this.type;
    }

    /**
     * Get the index property: The index property.
     *
     * @return the index value.
     */
    @Generated
    public int getIndex() {
        return this.index;
    }

    /**
     * Get the fileId property: The file_id property.
     *
     * @return the fileId value.
     */
    @Generated
    public String getFileId() {
        return this.fileId;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.index);
        jsonWriter.writeStringField("file_id", this.fileId);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesOutputTextAnnotationFileCitation from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesOutputTextAnnotationFileCitation if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponsesOutputTextAnnotationFileCitation.
     */
    @Generated
    public static ResponsesOutputTextAnnotationFileCitation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int index = 0;
            String fileId = null;
            ResponseOutputTextAnnotationType type = ResponseOutputTextAnnotationType.FILE_CITATION;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                } else if ("file_id".equals(fieldName)) {
                    fileId = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = ResponseOutputTextAnnotationType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ResponsesOutputTextAnnotationFileCitation deserializedResponsesOutputTextAnnotationFileCitation
                = new ResponsesOutputTextAnnotationFileCitation(index, fileId);
            deserializedResponsesOutputTextAnnotationFileCitation.type = type;
            return deserializedResponsesOutputTextAnnotationFileCitation;
        });
    }

    /**
     * Creates an instance of ResponsesOutputTextAnnotationFileCitation class.
     *
     * @param index the index value to set.
     * @param fileId the fileId value to set.
     */
    @Generated
    public ResponsesOutputTextAnnotationFileCitation(int index, String fileId) {
        this.index = index;
        this.fileId = fileId;
    }
}
