// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ResponsesOutputTextAnnotationFilePath model.
 */
@Immutable
public final class ResponsesOutputTextAnnotationFilePath extends ResponsesOutputTextAnnotation {

    /*
     * The type property.
     */
    @Generated
    private ResponseOutputTextAnnotationType type = ResponseOutputTextAnnotationType.FILE_PATH;

    /*
     * The file_id property.
     */
    @Generated
    private final String fileId;

    /*
     * The index property.
     */
    @Generated
    private final int index;

    /**
     * Creates an instance of ResponsesOutputTextAnnotationFilePath class.
     *
     * @param fileId the fileId value to set.
     * @param index the index value to set.
     */
    @Generated
    public ResponsesOutputTextAnnotationFilePath(String fileId, int index) {
        this.fileId = fileId;
        this.index = index;
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public ResponseOutputTextAnnotationType getType() {
        return this.type;
    }

    /**
     * Get the fileId property: The file_id property.
     *
     * @return the fileId value.
     */
    @Generated
    public String getFileId() {
        return this.fileId;
    }

    /**
     * Get the index property: The index property.
     *
     * @return the index value.
     */
    @Generated
    public int getIndex() {
        return this.index;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("file_id", this.fileId);
        jsonWriter.writeIntField("index", this.index);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesOutputTextAnnotationFilePath from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesOutputTextAnnotationFilePath if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponsesOutputTextAnnotationFilePath.
     */
    @Generated
    public static ResponsesOutputTextAnnotationFilePath fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String fileId = null;
            int index = 0;
            ResponseOutputTextAnnotationType type = ResponseOutputTextAnnotationType.FILE_PATH;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_id".equals(fieldName)) {
                    fileId = reader.getString();
                } else if ("index".equals(fieldName)) {
                    index = reader.getInt();
                } else if ("type".equals(fieldName)) {
                    type = ResponseOutputTextAnnotationType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ResponsesOutputTextAnnotationFilePath deserializedResponsesOutputTextAnnotationFilePath
                = new ResponsesOutputTextAnnotationFilePath(fileId, index);
            deserializedResponsesOutputTextAnnotationFilePath.type = type;
            return deserializedResponsesOutputTextAnnotationFilePath;
        });
    }
}
