// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.openai.responses.models;

/**
 * Defines values for ResponsesOutputTextAnnotationType.
 */
public enum ResponsesOutputTextAnnotationType {
    /**
     * Enum value file_citation.
     */
    FILE_CITATION("file_citation"),

    /**
     * Enum value file_path.
     */
    FILE_PATH("file_path");

    /**
     * The actual serialized value for a ResponsesOutputTextAnnotationType instance.
     */
    private final String value;

    ResponsesOutputTextAnnotationType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ResponsesOutputTextAnnotationType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ResponsesOutputTextAnnotationType object, or null if unable to parse.
     */
    public static ResponsesOutputTextAnnotationType fromString(String value) {
        if (value == null) {
            return null;
        }
        ResponsesOutputTextAnnotationType[] items = ResponsesOutputTextAnnotationType.values();
        for (ResponsesOutputTextAnnotationType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
