// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;

/**
 * The ResponsesResponse model.
 */
@Immutable
public final class ResponsesResponse implements JsonSerializable<ResponsesResponse> {

    /*
     * A unique identifier for this Response.
     */
    @Generated
    private final String id;

    /*
     * The object type of this resource - always set to `response`.
     */
    @Generated
    private final String object = "response";

    /*
     * Unix timestamp (in seconds) of when this Response was created.
     */
    @Generated
    private final long createdAt;

    /*
     * The status of the response generation.
     */
    @Generated
    private ResponsesResponseStatus status;

    /*
     * The error property.
     */
    @Generated
    private final ResponsesError error;

    /*
     * The incomplete_details property.
     */
    @Generated
    private final ResponsesResponseIncompleteDetails incompleteDetails;

    /*
     * The instructions property.
     */
    @Generated
    private final String instructions;

    /*
     * The max_output_tokens property.
     */
    @Generated
    private Integer maxOutputTokens;

    /*
     * The model used to generate this Response.
     */
    @Generated
    private final String model;

    /*
     * An array of content items generated by the model.
     */
    @Generated
    private final List<ResponsesItem> output;

    /*
     * The parallel_tool_calls property.
     */
    @Generated
    private final boolean parallelToolCalls;

    /*
     * The unique ID of the previous response to the model. Use this to create multi-turn conversations.
     */
    @Generated
    private final String previousResponseId;

    /*
     * The reasoning property.
     */
    @Generated
    private ResponsesReasoningConfiguration reasoning;

    /*
     * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while
     * lower values like 0.2 will make it more focused and deterministic.
     * 
     * We generally recommend altering this or `top_p` but not both.
     */
    @Generated
    private final double temperature;

    /*
     * The text property.
     */
    @Generated
    private ResponseTextOptions text;

    /*
     * The tool_choice property.
     */
    @Generated
    private final BinaryData toolChoice;

    /*
     * The tools available to the model when generating a Response.
     */
    @Generated
    private final List<ResponsesTool> tools;

    /*
     * An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of
     * the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are
     * considered.
     */
    @Generated
    private final double topP;

    /*
     * The truncation strategy to use for the model response.
     * - `auto`: If the context of this response and previous ones exceeds the model's context window size, the model
     * will truncate the response to fit the context window by dropping input items in the middle of the conversation.
     * - `disabled`: If a model response will exceed the context window size for a model, the request will fail with a
     * 400 error.
     */
    @Generated
    private ResponseTruncation truncation;

    /*
     * The usage property.
     */
    @Generated
    private ResponsesResponseUsage usage;

    /*
     * The user property.
     */
    @Generated
    private String user;

    /*
     * Set of 16 key-value pairs that can be attached to an object. This can be
     * useful for storing additional information about the object in a structured
     * format, and querying for objects via API or the dashboard.
     * 
     * Keys are strings with a maximum length of 64 characters. Values are strings
     * with a maximum length of 512 characters.
     */
    @Generated
    private final Map<String, String> metadata;

    /**
     * Get the id property: A unique identifier for this Response.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the object property: The object type of this resource - always set to `response`.
     *
     * @return the object value.
     */
    @Generated
    public String getObject() {
        return this.object;
    }

    /**
     * Get the createdAt property: Unix timestamp (in seconds) of when this Response was created.
     *
     * @return the createdAt value.
     */
    @Generated
    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    /**
     * Get the status property: The status of the response generation.
     *
     * @return the status value.
     */
    @Generated
    public ResponsesResponseStatus getStatus() {
        return this.status;
    }

    /**
     * Get the error property: The error property.
     *
     * @return the error value.
     */
    @Generated
    public ResponsesError getError() {
        return this.error;
    }

    /**
     * Get the incompleteDetails property: The incomplete_details property.
     *
     * @return the incompleteDetails value.
     */
    @Generated
    public ResponsesResponseIncompleteDetails getIncompleteDetails() {
        return this.incompleteDetails;
    }

    /**
     * Get the instructions property: The instructions property.
     *
     * @return the instructions value.
     */
    @Generated
    public String getInstructions() {
        return this.instructions;
    }

    /**
     * Get the maxOutputTokens property: The max_output_tokens property.
     *
     * @return the maxOutputTokens value.
     */
    @Generated
    public Integer getMaxOutputTokens() {
        return this.maxOutputTokens;
    }

    /**
     * Get the model property: The model used to generate this Response.
     *
     * @return the model value.
     */
    @Generated
    public String getModel() {
        return this.model;
    }

    /**
     * Get the output property: An array of content items generated by the model.
     *
     * @return the output value.
     */
    @Generated
    public List<ResponsesItem> getOutput() {
        return this.output;
    }

    /**
     * Get the parallelToolCalls property: The parallel_tool_calls property.
     *
     * @return the parallelToolCalls value.
     */
    @Generated
    public boolean isParallelToolCalls() {
        return this.parallelToolCalls;
    }

    /**
     * Get the previousResponseId property: The unique ID of the previous response to the model. Use this to create
     * multi-turn conversations.
     *
     * @return the previousResponseId value.
     */
    @Generated
    public String getPreviousResponseId() {
        return this.previousResponseId;
    }

    /**
     * Get the reasoning property: The reasoning property.
     *
     * @return the reasoning value.
     */
    @Generated
    public ResponsesReasoningConfiguration getReasoning() {
        return this.reasoning;
    }

    /**
     * Get the temperature property: What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make
     * the output more random, while lower values like 0.2 will make it more focused and deterministic.
     *
     * We generally recommend altering this or `top_p` but not both.
     *
     * @return the temperature value.
     */
    @Generated
    public double getTemperature() {
        return this.temperature;
    }

    /**
     * Get the text property: The text property.
     *
     * @return the text value.
     */
    @Generated
    public ResponseTextOptions getText() {
        return this.text;
    }

    /**
     * Get the toolChoice property: The tool_choice property.
     *
     * @return the toolChoice value.
     */
    @Generated
    public BinaryData getToolChoice() {
        return this.toolChoice;
    }

    /**
     * Get the tools property: The tools available to the model when generating a Response.
     *
     * @return the tools value.
     */
    @Generated
    public List<ResponsesTool> getTools() {
        return this.tools;
    }

    /**
     * Get the topP property: An alternative to sampling with temperature, called nucleus sampling, where the model
     * considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top
     * 10% probability mass are considered.
     *
     * @return the topP value.
     */
    @Generated
    public double getTopP() {
        return this.topP;
    }

    /**
     * Get the truncation property: The truncation strategy to use for the model response.
     * - `auto`: If the context of this response and previous ones exceeds the model's context window size, the model
     * will truncate the response to fit the context window by dropping input items in the middle of the conversation.
     * - `disabled`: If a model response will exceed the context window size for a model, the request will fail with a
     * 400 error.
     *
     * @return the truncation value.
     */
    @Generated
    public ResponseTruncation getTruncation() {
        return this.truncation;
    }

    /**
     * Get the usage property: The usage property.
     *
     * @return the usage value.
     */
    @Generated
    public ResponsesResponseUsage getUsage() {
        return this.usage;
    }

    /**
     * Get the user property: The user property.
     *
     * @return the user value.
     */
    @Generated
    public String getUser() {
        return this.user;
    }

    /**
     * Get the metadata property: Set of 16 key-value pairs that can be attached to an object. This can be
     * useful for storing additional information about the object in a structured
     * format, and querying for objects via API or the dashboard.
     *
     * Keys are strings with a maximum length of 64 characters. Values are strings
     * with a maximum length of 512 characters.
     *
     * @return the metadata value.
     */
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeJsonField("error", this.error);
        jsonWriter.writeJsonField("incomplete_details", this.incompleteDetails);
        jsonWriter.writeStringField("instructions", this.instructions);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeArrayField("output", this.output, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("parallel_tool_calls", this.parallelToolCalls);
        jsonWriter.writeStringField("previous_response_id", this.previousResponseId);
        jsonWriter.writeDoubleField("temperature", this.temperature);
        jsonWriter.writeFieldName("tool_choice");
        this.toolChoice.writeTo(jsonWriter);
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeDoubleField("top_p", this.topP);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeNumberField("max_output_tokens", this.maxOutputTokens);
        jsonWriter.writeJsonField("reasoning", this.reasoning);
        jsonWriter.writeJsonField("text", this.text);
        jsonWriter.writeStringField("truncation", this.truncation == null ? null : this.truncation.toString());
        jsonWriter.writeJsonField("usage", this.usage);
        jsonWriter.writeStringField("user", this.user);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesResponse from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesResponse if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponsesResponse.
     */
    @Generated
    public static ResponsesResponse fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            ResponsesError error = null;
            ResponsesResponseIncompleteDetails incompleteDetails = null;
            String instructions = null;
            String model = null;
            List<ResponsesItem> output = null;
            boolean parallelToolCalls = false;
            String previousResponseId = null;
            double temperature = 0.0;
            BinaryData toolChoice = null;
            List<ResponsesTool> tools = null;
            double topP = 0.0;
            Map<String, String> metadata = null;
            ResponsesResponseStatus status = null;
            Integer maxOutputTokens = null;
            ResponsesReasoningConfiguration reasoning = null;
            ResponseTextOptions text = null;
            ResponseTruncation truncation = null;
            ResponsesResponseUsage usage = null;
            String user = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                } else if ("error".equals(fieldName)) {
                    error = ResponsesError.fromJson(reader);
                } else if ("incomplete_details".equals(fieldName)) {
                    incompleteDetails = ResponsesResponseIncompleteDetails.fromJson(reader);
                } else if ("instructions".equals(fieldName)) {
                    instructions = reader.getString();
                } else if ("model".equals(fieldName)) {
                    model = reader.getString();
                } else if ("output".equals(fieldName)) {
                    output = reader.readArray(reader1 -> ResponsesItem.fromJson(reader1));
                } else if ("parallel_tool_calls".equals(fieldName)) {
                    parallelToolCalls = reader.getBoolean();
                } else if ("previous_response_id".equals(fieldName)) {
                    previousResponseId = reader.getString();
                } else if ("temperature".equals(fieldName)) {
                    temperature = reader.getDouble();
                } else if ("tool_choice".equals(fieldName)) {
                    toolChoice
                        = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ResponsesTool.fromJson(reader1));
                } else if ("top_p".equals(fieldName)) {
                    topP = reader.getDouble();
                } else if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                } else if ("status".equals(fieldName)) {
                    status = ResponsesResponseStatus.fromString(reader.getString());
                } else if ("max_output_tokens".equals(fieldName)) {
                    maxOutputTokens = reader.getNullable(JsonReader::getInt);
                } else if ("reasoning".equals(fieldName)) {
                    reasoning = ResponsesReasoningConfiguration.fromJson(reader);
                } else if ("text".equals(fieldName)) {
                    text = ResponseTextOptions.fromJson(reader);
                } else if ("truncation".equals(fieldName)) {
                    truncation = ResponseTruncation.fromString(reader.getString());
                } else if ("usage".equals(fieldName)) {
                    usage = ResponsesResponseUsage.fromJson(reader);
                } else if ("user".equals(fieldName)) {
                    user = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            ResponsesResponse deserializedResponsesResponse
                = new ResponsesResponse(id, createdAt, error, incompleteDetails, instructions, model, output,
                    parallelToolCalls, previousResponseId, temperature, toolChoice, tools, topP, metadata);
            deserializedResponsesResponse.status = status;
            deserializedResponsesResponse.maxOutputTokens = maxOutputTokens;
            deserializedResponsesResponse.reasoning = reasoning;
            deserializedResponsesResponse.text = text;
            deserializedResponsesResponse.truncation = truncation;
            deserializedResponsesResponse.usage = usage;
            deserializedResponsesResponse.user = user;
            return deserializedResponsesResponse;
        });
    }

    /**
     * Creates an instance of ResponsesResponse class.
     *
     * @param id the id value to set.
     * @param createdAt the createdAt value to set.
     * @param error the error value to set.
     * @param incompleteDetails the incompleteDetails value to set.
     * @param instructions the instructions value to set.
     * @param model the model value to set.
     * @param output the output value to set.
     * @param parallelToolCalls the parallelToolCalls value to set.
     * @param previousResponseId the previousResponseId value to set.
     * @param temperature the temperature value to set.
     * @param toolChoice the toolChoice value to set.
     * @param tools the tools value to set.
     * @param topP the topP value to set.
     * @param metadata the metadata value to set.
     */
    @Generated
    private ResponsesResponse(String id, OffsetDateTime createdAt, ResponsesError error,
        ResponsesResponseIncompleteDetails incompleteDetails, String instructions, String model,
        List<ResponsesItem> output, boolean parallelToolCalls, String previousResponseId, double temperature,
        BinaryData toolChoice, List<ResponsesTool> tools, double topP, Map<String, String> metadata) {
        this.id = id;
        if (createdAt == null) {
            this.createdAt = 0L;
        } else {
            this.createdAt = createdAt.toEpochSecond();
        }
        this.error = error;
        this.incompleteDetails = incompleteDetails;
        this.instructions = instructions;
        this.model = model;
        this.output = output;
        this.parallelToolCalls = parallelToolCalls;
        this.previousResponseId = previousResponseId;
        this.temperature = temperature;
        this.toolChoice = toolChoice;
        this.tools = tools;
        this.topP = topP;
        this.metadata = metadata;
    }
}
