// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.openai.responses.models;

/**
 * Defines values for ResponsesResponseStatus.
 */
public enum ResponsesResponseStatus {
    /**
     * Enum value completed.
     */
    COMPLETED("completed"),

    /**
     * Enum value in_progress.
     */
    IN_PROGRESS("in_progress"),

    /**
     * Enum value failed.
     */
    FAILED("failed"),

    /**
     * Enum value incomplete.
     */
    INCOMPLETE("incomplete");

    /**
     * The actual serialized value for a ResponsesResponseStatus instance.
     */
    private final String value;

    ResponsesResponseStatus(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ResponsesResponseStatus instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ResponsesResponseStatus object, or null if unable to parse.
     */
    public static ResponsesResponseStatus fromString(String value) {
        if (value == null) {
            return null;
        }
        ResponsesResponseStatus[] items = ResponsesResponseStatus.values();
        for (ResponsesResponseStatus item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
