// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Returned when a Response is done streaming. Always emitted, no matter the
 * final state. The Response object included in the `response.completed` event will
 * include all output Items in the Response but will omit the raw audio data.
 */
@Immutable
public final class ResponsesStreamEventCompleted extends ResponsesStreamEvent {

    /*
     * The type property.
     */
    @Generated
    private ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_COMPLETED;

    /*
     * The completed response.
     */
    @Generated
    private final ResponsesResponse response;

    /**
     * Creates an instance of ResponsesStreamEventCompleted class.
     *
     * @param response the response value to set.
     */
    @Generated
    private ResponsesStreamEventCompleted(ResponsesResponse response) {
        this.response = response;
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public ResponsesStreamEventType getType() {
        return this.type;
    }

    /**
     * Get the response property: The completed response.
     *
     * @return the response value.
     */
    @Generated
    public ResponsesResponse getResponse() {
        return this.response;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("response", this.response);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesStreamEventCompleted from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesStreamEventCompleted if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponsesStreamEventCompleted.
     */
    @Generated
    public static ResponsesStreamEventCompleted fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResponsesResponse response = null;
            ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_COMPLETED;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("response".equals(fieldName)) {
                    response = ResponsesResponse.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = ResponsesStreamEventType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ResponsesStreamEventCompleted deserializedResponsesStreamEventCompleted
                = new ResponsesStreamEventCompleted(response);
            deserializedResponsesStreamEventCompleted.type = type;
            return deserializedResponsesStreamEventCompleted;
        });
    }
}
