// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Emitted when an error has occurred.
 */
@Immutable
public final class ResponsesStreamEventError extends ResponsesStreamEvent {

    /*
     * The type property.
     */
    @Generated
    private ResponsesStreamEventType type = ResponsesStreamEventType.ERROR;

    /*
     * The error message.
     */
    @Generated
    private final String message;

    /*
     * The error code, if applicable.
     */
    @Generated
    private final String code;

    /*
     * The parameter the error applies to, if applicable.
     */
    @Generated
    private final String param;

    /**
     * Creates an instance of ResponsesStreamEventError class.
     *
     * @param message the message value to set.
     * @param code the code value to set.
     * @param param the param value to set.
     */
    @Generated
    private ResponsesStreamEventError(String message, String code, String param) {
        this.message = message;
        this.code = code;
        this.param = param;
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public ResponsesStreamEventType getType() {
        return this.type;
    }

    /**
     * Get the message property: The error message.
     *
     * @return the message value.
     */
    @Generated
    public String getMessage() {
        return this.message;
    }

    /**
     * Get the code property: The error code, if applicable.
     *
     * @return the code value.
     */
    @Generated
    public String getCode() {
        return this.code;
    }

    /**
     * Get the param property: The parameter the error applies to, if applicable.
     *
     * @return the param value.
     */
    @Generated
    public String getParam() {
        return this.param;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("param", this.param);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesStreamEventError from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesStreamEventError if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponsesStreamEventError.
     */
    @Generated
    public static ResponsesStreamEventError fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String message = null;
            String code = null;
            String param = null;
            ResponsesStreamEventType type = ResponsesStreamEventType.ERROR;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                } else if ("code".equals(fieldName)) {
                    code = reader.getString();
                } else if ("param".equals(fieldName)) {
                    param = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = ResponsesStreamEventType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ResponsesStreamEventError deserializedResponsesStreamEventError
                = new ResponsesStreamEventError(message, code, param);
            deserializedResponsesStreamEventError.type = type;
            return deserializedResponsesStreamEventError;
        });
    }
}
