// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ResponsesTextFormatJsonSchema model.
 */
@Fluent
public final class ResponsesTextFormatJsonSchema extends ResponsesTextFormat {

    /*
     * The type property.
     */
    @Generated
    private ResponsesTextFormatType type = ResponsesTextFormatType.JSON_SCHEMA;

    /*
     * The name property.
     */
    @Generated
    private final String name;

    /*
     * The schema property.
     */
    @Generated
    private final BinaryData schema;

    /*
     * The description property.
     */
    @Generated
    private String description;

    /*
     * The strict property.
     */
    @Generated
    private Boolean strict;

    /**
     * Creates an instance of ResponsesTextFormatJsonSchema class.
     *
     * @param name the name value to set.
     * @param schema the schema value to set.
     */
    @Generated
    public ResponsesTextFormatJsonSchema(String name, BinaryData schema) {
        this.name = name;
        this.schema = schema;
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public ResponsesTextFormatType getType() {
        return this.type;
    }

    /**
     * Get the name property: The name property.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the schema property: The schema property.
     *
     * @return the schema value.
     */
    @Generated
    public BinaryData getSchema() {
        return this.schema;
    }

    /**
     * Get the description property: The description property.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     *
     * @param description the description value to set.
     * @return the ResponsesTextFormatJsonSchema object itself.
     */
    @Generated
    public ResponsesTextFormatJsonSchema setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the strict property: The strict property.
     *
     * @return the strict value.
     */
    @Generated
    public Boolean isStrict() {
        return this.strict;
    }

    /**
     * Set the strict property: The strict property.
     *
     * @param strict the strict value to set.
     * @return the ResponsesTextFormatJsonSchema object itself.
     */
    @Generated
    public ResponsesTextFormatJsonSchema setStrict(Boolean strict) {
        this.strict = strict;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeFieldName("schema");
        this.schema.writeTo(jsonWriter);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeBooleanField("strict", this.strict);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesTextFormatJsonSchema from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesTextFormatJsonSchema if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponsesTextFormatJsonSchema.
     */
    @Generated
    public static ResponsesTextFormatJsonSchema fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String name = null;
            BinaryData schema = null;
            ResponsesTextFormatType type = ResponsesTextFormatType.JSON_SCHEMA;
            String description = null;
            Boolean strict = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("schema".equals(fieldName)) {
                    schema = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("type".equals(fieldName)) {
                    type = ResponsesTextFormatType.fromString(reader.getString());
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("strict".equals(fieldName)) {
                    strict = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }
            ResponsesTextFormatJsonSchema deserializedResponsesTextFormatJsonSchema
                = new ResponsesTextFormatJsonSchema(name, schema);
            deserializedResponsesTextFormatJsonSchema.type = type;
            deserializedResponsesTextFormatJsonSchema.description = description;
            deserializedResponsesTextFormatJsonSchema.strict = strict;
            return deserializedResponsesTextFormatJsonSchema;
        });
    }
}
