// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ResponsesToolChoiceObject model.
 */
@Immutable
public class ResponsesToolChoiceObject implements JsonSerializable<ResponsesToolChoiceObject> {

    /*
     * The type property.
     */
    @Generated
    private ResponsesToolChoiceObjectType type;

    /**
     * Creates an instance of ResponsesToolChoiceObject class.
     */
    @Generated
    public ResponsesToolChoiceObject() {
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    public ResponsesToolChoiceObjectType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesToolChoiceObject from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesToolChoiceObject if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResponsesToolChoiceObject.
     */
    @Generated
    public static ResponsesToolChoiceObject fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("function".equals(discriminatorValue)) {
                    return ResponsesToolChoiceObjectFunction.fromJson(readerToUse.reset());
                } else if ("file_search".equals(discriminatorValue)) {
                    return ResponsesToolChoiceObjectFileSearch.fromJson(readerToUse.reset());
                } else if ("web_search_preview".equals(discriminatorValue)) {
                    return ResponsesToolChoiceObjectWebSearch.fromJson(readerToUse.reset());
                } else if ("computer_use_preview".equals(discriminatorValue)) {
                    return ResponsesToolChoiceObjectComputer.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static ResponsesToolChoiceObject fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResponsesToolChoiceObject deserializedResponsesToolChoiceObject = new ResponsesToolChoiceObject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedResponsesToolChoiceObject.type
                        = ResponsesToolChoiceObjectType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedResponsesToolChoiceObject;
        });
    }
}
