// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ResponsesToolChoiceObjectFunction model.
 */
@Immutable
public final class ResponsesToolChoiceObjectFunction extends ResponsesToolChoiceObject {

    /*
     * The type property.
     */
    @Generated
    private ResponsesToolChoiceObjectType type = ResponsesToolChoiceObjectType.FUNCTION;

    /*
     * The name property.
     */
    @Generated
    private final String name;

    /**
     * Creates an instance of ResponsesToolChoiceObjectFunction class.
     *
     * @param name the name value to set.
     */
    @Generated
    public ResponsesToolChoiceObjectFunction(String name) {
        this.name = name;
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public ResponsesToolChoiceObjectType getType() {
        return this.type;
    }

    /**
     * Get the name property: The name property.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesToolChoiceObjectFunction from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesToolChoiceObjectFunction if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponsesToolChoiceObjectFunction.
     */
    @Generated
    public static ResponsesToolChoiceObjectFunction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String name = null;
            ResponsesToolChoiceObjectType type = ResponsesToolChoiceObjectType.FUNCTION;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = ResponsesToolChoiceObjectType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ResponsesToolChoiceObjectFunction deserializedResponsesToolChoiceObjectFunction
                = new ResponsesToolChoiceObjectFunction(name);
            deserializedResponsesToolChoiceObjectFunction.type = type;
            return deserializedResponsesToolChoiceObjectFunction;
        });
    }
}
