/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.OutputAudioFormat;
import com.azure.ai.openai.models.SpeechVoice;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AudioOutputParameters
implements JsonSerializable<AudioOutputParameters> {
    private final SpeechVoice voice;
    private final OutputAudioFormat format;

    public AudioOutputParameters(SpeechVoice voice, OutputAudioFormat format) {
        this.voice = voice;
        this.format = format;
    }

    public SpeechVoice getVoice() {
        return this.voice;
    }

    public OutputAudioFormat getFormat() {
        return this.format;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("voice", this.voice == null ? null : this.voice.toString());
        jsonWriter.writeStringField("format", this.format == null ? null : this.format.toString());
        return jsonWriter.writeEndObject();
    }

    public static AudioOutputParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AudioOutputParameters)jsonReader.readObject(reader -> {
            SpeechVoice voice = null;
            OutputAudioFormat format = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("voice".equals(fieldName)) {
                    voice = SpeechVoice.fromString(reader.getString());
                    continue;
                }
                if ("format".equals(fieldName)) {
                    format = OutputAudioFormat.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return new AudioOutputParameters(voice, format);
        });
    }
}

