/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.AzureCosmosDBFieldMappingOptions;
import com.azure.ai.openai.models.OnYourDataAuthenticationOptions;
import com.azure.ai.openai.models.OnYourDataContextProperty;
import com.azure.ai.openai.models.OnYourDataVectorizationSource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AzureCosmosDBChatExtensionParameters
implements JsonSerializable<AzureCosmosDBChatExtensionParameters> {
    private OnYourDataAuthenticationOptions authentication;
    private Integer topNDocuments;
    private Boolean inScope;
    private Integer strictness;
    private final String databaseName;
    private final String containerName;
    private final String indexName;
    private final AzureCosmosDBFieldMappingOptions fieldsMapping;
    private final OnYourDataVectorizationSource embeddingDependency;
    private Integer maxSearchQueries;
    private Boolean allowPartialResult;
    private List<OnYourDataContextProperty> includeContexts;

    public OnYourDataAuthenticationOptions getAuthentication() {
        return this.authentication;
    }

    public AzureCosmosDBChatExtensionParameters setAuthentication(OnYourDataAuthenticationOptions authentication) {
        this.authentication = authentication;
        return this;
    }

    public Integer getTopNDocuments() {
        return this.topNDocuments;
    }

    public AzureCosmosDBChatExtensionParameters setTopNDocuments(Integer topNDocuments) {
        this.topNDocuments = topNDocuments;
        return this;
    }

    public Boolean isInScope() {
        return this.inScope;
    }

    public AzureCosmosDBChatExtensionParameters setInScope(Boolean inScope) {
        this.inScope = inScope;
        return this;
    }

    public Integer getStrictness() {
        return this.strictness;
    }

    public AzureCosmosDBChatExtensionParameters setStrictness(Integer strictness) {
        this.strictness = strictness;
        return this;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public AzureCosmosDBFieldMappingOptions getFieldsMapping() {
        return this.fieldsMapping;
    }

    public OnYourDataVectorizationSource getEmbeddingDependency() {
        return this.embeddingDependency;
    }

    public AzureCosmosDBChatExtensionParameters(String databaseName, String containerName, String indexName, AzureCosmosDBFieldMappingOptions fieldsMapping, OnYourDataVectorizationSource embeddingDependency) {
        this.databaseName = databaseName;
        this.containerName = containerName;
        this.indexName = indexName;
        this.fieldsMapping = fieldsMapping;
        this.embeddingDependency = embeddingDependency;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("database_name", this.databaseName);
        jsonWriter.writeStringField("container_name", this.containerName);
        jsonWriter.writeStringField("index_name", this.indexName);
        jsonWriter.writeJsonField("fields_mapping", (JsonSerializable)this.fieldsMapping);
        jsonWriter.writeJsonField("embedding_dependency", (JsonSerializable)this.embeddingDependency);
        jsonWriter.writeNumberField("top_n_documents", (Number)this.topNDocuments);
        jsonWriter.writeBooleanField("in_scope", this.inScope);
        jsonWriter.writeNumberField("strictness", (Number)this.strictness);
        jsonWriter.writeNumberField("max_search_queries", (Number)this.maxSearchQueries);
        jsonWriter.writeBooleanField("allow_partial_result", this.allowPartialResult);
        jsonWriter.writeArrayField("include_contexts", this.includeContexts, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("authentication", (JsonSerializable)this.authentication);
        return jsonWriter.writeEndObject();
    }

    public static AzureCosmosDBChatExtensionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AzureCosmosDBChatExtensionParameters)jsonReader.readObject(reader -> {
            String databaseName = null;
            String containerName = null;
            String indexName = null;
            AzureCosmosDBFieldMappingOptions fieldsMapping = null;
            OnYourDataVectorizationSource embeddingDependency = null;
            Integer topNDocuments = null;
            Boolean inScope = null;
            Integer strictness = null;
            Integer maxSearchQueries = null;
            Boolean allowPartialResult = null;
            List includeContexts = null;
            OnYourDataAuthenticationOptions authentication = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("database_name".equals(fieldName)) {
                    databaseName = reader.getString();
                    continue;
                }
                if ("container_name".equals(fieldName)) {
                    containerName = reader.getString();
                    continue;
                }
                if ("index_name".equals(fieldName)) {
                    indexName = reader.getString();
                    continue;
                }
                if ("fields_mapping".equals(fieldName)) {
                    fieldsMapping = AzureCosmosDBFieldMappingOptions.fromJson(reader);
                    continue;
                }
                if ("embedding_dependency".equals(fieldName)) {
                    embeddingDependency = OnYourDataVectorizationSource.fromJson(reader);
                    continue;
                }
                if ("top_n_documents".equals(fieldName)) {
                    topNDocuments = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("in_scope".equals(fieldName)) {
                    inScope = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("strictness".equals(fieldName)) {
                    strictness = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("max_search_queries".equals(fieldName)) {
                    maxSearchQueries = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allow_partial_result".equals(fieldName)) {
                    allowPartialResult = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("include_contexts".equals(fieldName)) {
                    includeContexts = reader.readArray(reader1 -> OnYourDataContextProperty.fromString(reader1.getString()));
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    authentication = OnYourDataAuthenticationOptions.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            AzureCosmosDBChatExtensionParameters deserializedAzureCosmosDBChatExtensionParameters = new AzureCosmosDBChatExtensionParameters(databaseName, containerName, indexName, fieldsMapping, embeddingDependency);
            deserializedAzureCosmosDBChatExtensionParameters.topNDocuments = topNDocuments;
            deserializedAzureCosmosDBChatExtensionParameters.inScope = inScope;
            deserializedAzureCosmosDBChatExtensionParameters.strictness = strictness;
            deserializedAzureCosmosDBChatExtensionParameters.maxSearchQueries = maxSearchQueries;
            deserializedAzureCosmosDBChatExtensionParameters.allowPartialResult = allowPartialResult;
            deserializedAzureCosmosDBChatExtensionParameters.includeContexts = includeContexts;
            deserializedAzureCosmosDBChatExtensionParameters.authentication = authentication;
            return deserializedAzureCosmosDBChatExtensionParameters;
        });
    }

    public Integer getMaxSearchQueries() {
        return this.maxSearchQueries;
    }

    public AzureCosmosDBChatExtensionParameters setMaxSearchQueries(Integer maxSearchQueries) {
        this.maxSearchQueries = maxSearchQueries;
        return this;
    }

    public Boolean isAllowPartialResult() {
        return this.allowPartialResult;
    }

    public AzureCosmosDBChatExtensionParameters setAllowPartialResult(Boolean allowPartialResult) {
        this.allowPartialResult = allowPartialResult;
        return this;
    }

    public List<OnYourDataContextProperty> getIncludeContexts() {
        return this.includeContexts;
    }

    public AzureCosmosDBChatExtensionParameters setIncludeContexts(List<OnYourDataContextProperty> includeContexts) {
        this.includeContexts = includeContexts;
        return this;
    }
}

