/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatTokenLogProbabilityResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ChatChoiceLogProbabilityInfo
implements JsonSerializable<ChatChoiceLogProbabilityInfo> {
    private final List<ChatTokenLogProbabilityResult> content;
    private final List<ChatTokenLogProbabilityResult> refusal;

    public List<ChatTokenLogProbabilityResult> getContent() {
        return this.content;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("content", this.content, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("refusal", this.refusal, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ChatChoiceLogProbabilityInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ChatChoiceLogProbabilityInfo)jsonReader.readObject(reader -> {
            List content = null;
            List refusal = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.readArray(reader1 -> ChatTokenLogProbabilityResult.fromJson(reader1));
                    continue;
                }
                if ("refusal".equals(fieldName)) {
                    refusal = reader.readArray(reader1 -> ChatTokenLogProbabilityResult.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new ChatChoiceLogProbabilityInfo(content, refusal);
        });
    }

    private ChatChoiceLogProbabilityInfo(List<ChatTokenLogProbabilityResult> content, List<ChatTokenLogProbabilityResult> refusal) {
        this.content = content;
        this.refusal = refusal;
    }

    public List<ChatTokenLogProbabilityResult> getRefusal() {
        return this.refusal;
    }
}

