/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatMessageContentItem;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRole;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class ChatRequestSystemMessage
extends ChatRequestMessage {
    private final BinaryData content;
    private final String stringContent;
    private final List<ChatMessageContentItem> chatMessageContentItems;
    private String name;
    private ChatRole role = ChatRole.SYSTEM;

    public BinaryData getContent() {
        return this.content;
    }

    public List<ChatMessageContentItem> getListContent() {
        return this.chatMessageContentItems;
    }

    public ChatMessageContentItem[] getArrayContent() {
        return this.chatMessageContentItems == null ? null : this.chatMessageContentItems.toArray(new ChatMessageContentItem[0]);
    }

    public String getStringContent() {
        return this.stringContent;
    }

    public String getName() {
        return this.name;
    }

    public ChatRequestSystemMessage setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.stringContent != null) {
            jsonWriter.writeStringField("content", this.stringContent);
        } else if (this.chatMessageContentItems != null) {
            jsonWriter.writeArrayField("content", this.chatMessageContentItems, JsonWriter::writeJson);
        } else {
            jsonWriter.writeNullField("content");
        }
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestSystemMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestSystemMessage)jsonReader.readObject(reader -> {
            Object content = null;
            String stringContent = null;
            List chatMessageContentItems = null;
            ChatRole role = ChatRole.SYSTEM;
            String name = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    if (reader.currentToken() == JsonToken.STRING) {
                        stringContent = reader.getString();
                        continue;
                    }
                    if (reader.currentToken() == JsonToken.START_ARRAY) {
                        chatMessageContentItems = reader.readArray(arrayReader -> (ChatMessageContentItem)arrayReader.readObject(ChatMessageContentItem::fromJson));
                        continue;
                    }
                    if (reader.currentToken() == JsonToken.NULL) {
                        content = null;
                        continue;
                    }
                    throw new IllegalStateException("Unexpected 'content' type found when deserializing ChatRequestSystemMessage JSON object: " + reader.currentToken());
                }
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ChatRequestSystemMessage deserializedChatRequestSystemMessage = CoreUtils.isNullOrEmpty(stringContent) && chatMessageContentItems == null ? new ChatRequestSystemMessage(content) : (CoreUtils.isNullOrEmpty(stringContent) ? new ChatRequestSystemMessage(chatMessageContentItems) : new ChatRequestSystemMessage(stringContent));
            deserializedChatRequestSystemMessage.role = role;
            deserializedChatRequestSystemMessage.name = name;
            return deserializedChatRequestSystemMessage;
        });
    }

    private ChatRequestSystemMessage(BinaryData content) {
        this.content = content;
        this.stringContent = null;
        this.chatMessageContentItems = null;
    }

    public ChatRequestSystemMessage(String content) {
        this.content = BinaryData.fromString((String)content);
        this.stringContent = content;
        this.chatMessageContentItems = null;
    }

    public ChatRequestSystemMessage(ChatMessageContentItem[] content) {
        this.content = BinaryData.fromObject((Object)content);
        this.chatMessageContentItems = Arrays.asList(content);
        this.stringContent = null;
    }

    public ChatRequestSystemMessage(List<ChatMessageContentItem> content) {
        this.content = BinaryData.fromObject(content);
        this.stringContent = null;
        this.chatMessageContentItems = content;
    }
}

