/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesContentType;
import com.azure.ai.openai.responses.models.ResponsesInputContentFile;
import com.azure.ai.openai.responses.models.ResponsesInputContentImage;
import com.azure.ai.openai.responses.models.ResponsesInputContentText;
import com.azure.ai.openai.responses.models.ResponsesOutputContentRefusal;
import com.azure.ai.openai.responses.models.ResponsesOutputContentText;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class ResponsesContent
implements JsonSerializable<ResponsesContent> {
    private ResponsesContentType type;

    public ResponsesContentType getType() {
        return this.type;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesContent fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesContent)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ResponsesContent responsesContent;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("input_text".equals(discriminatorValue)) {
                    responsesContent = ResponsesInputContentText.fromJson(readerToUse.reset());
                    return responsesContent;
                }
                if ("input_image".equals(discriminatorValue)) {
                    responsesContent = ResponsesInputContentImage.fromJson(readerToUse.reset());
                    return responsesContent;
                }
                if ("input_file".equals(discriminatorValue)) {
                    responsesContent = ResponsesInputContentFile.fromJson(readerToUse.reset());
                    return responsesContent;
                }
                if ("output_text".equals(discriminatorValue)) {
                    responsesContent = ResponsesOutputContentText.fromJson(readerToUse.reset());
                    return responsesContent;
                }
                if ("refusal".equals(discriminatorValue)) {
                    responsesContent = ResponsesOutputContentRefusal.fromJson(readerToUse.reset());
                    return responsesContent;
                }
                responsesContent = ResponsesContent.fromJsonKnownDiscriminator(readerToUse.reset());
                return responsesContent;
            }
        });
    }

    static ResponsesContent fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ResponsesContent)jsonReader.readObject(reader -> {
            ResponsesContent deserializedResponsesContent = new ResponsesContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedResponsesContent.type = ResponsesContentType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResponsesContent;
        });
    }
}

