/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesContent;
import com.azure.ai.openai.responses.models.ResponsesContentType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesInputContentFile
extends ResponsesContent {
    private ResponsesContentType type = ResponsesContentType.INPUT_FILE;
    private String fileId;
    private String filename;
    private String fileData;

    @Override
    public ResponsesContentType getType() {
        return this.type;
    }

    public String getFileId() {
        return this.fileId;
    }

    public ResponsesInputContentFile setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    public String getFilename() {
        return this.filename;
    }

    public ResponsesInputContentFile setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public String getFileData() {
        return this.fileData;
    }

    public ResponsesInputContentFile setFileData(String fileData) {
        this.fileData = fileData;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("file_id", this.fileId);
        jsonWriter.writeStringField("filename", this.filename);
        jsonWriter.writeStringField("file_data", this.fileData);
        return jsonWriter.writeEndObject();
    }

    public static ResponsesInputContentFile fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesInputContentFile)jsonReader.readObject(reader -> {
            ResponsesInputContentFile deserializedResponsesInputContentFile = new ResponsesInputContentFile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedResponsesInputContentFile.type = ResponsesContentType.fromString(reader.getString());
                    continue;
                }
                if ("file_id".equals(fieldName)) {
                    deserializedResponsesInputContentFile.fileId = reader.getString();
                    continue;
                }
                if ("filename".equals(fieldName)) {
                    deserializedResponsesInputContentFile.filename = reader.getString();
                    continue;
                }
                if ("file_data".equals(fieldName)) {
                    deserializedResponsesInputContentFile.fileData = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResponsesInputContentFile;
        });
    }
}

