/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesComputerCallItem;
import com.azure.ai.openai.responses.models.ResponsesComputerCallOutputItem;
import com.azure.ai.openai.responses.models.ResponsesFileSearchCallItem;
import com.azure.ai.openai.responses.models.ResponsesFunctionCallItem;
import com.azure.ai.openai.responses.models.ResponsesFunctionCallOutput;
import com.azure.ai.openai.responses.models.ResponsesItemReferenceItem;
import com.azure.ai.openai.responses.models.ResponsesItemType;
import com.azure.ai.openai.responses.models.ResponsesMessage;
import com.azure.ai.openai.responses.models.ResponsesReasoningItem;
import com.azure.ai.openai.responses.models.ResponsesWebSearchCallItem;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class ResponsesItem
implements JsonSerializable<ResponsesItem> {
    private ResponsesItemType type;
    private String id;

    public ResponsesItemType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    ResponsesItem setId(String id) {
        this.id = id;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesItem fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesItem)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ResponsesItem responsesItem;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("message".equals(discriminatorValue)) {
                    responsesItem = ResponsesMessage.fromJson(readerToUse.reset());
                    return responsesItem;
                }
                if ("function_call".equals(discriminatorValue)) {
                    responsesItem = ResponsesFunctionCallItem.fromJson(readerToUse.reset());
                    return responsesItem;
                }
                if ("function_call_output".equals(discriminatorValue)) {
                    responsesItem = ResponsesFunctionCallOutput.fromJson(readerToUse.reset());
                    return responsesItem;
                }
                if ("computer_call".equals(discriminatorValue)) {
                    responsesItem = ResponsesComputerCallItem.fromJson(readerToUse.reset());
                    return responsesItem;
                }
                if ("computer_call_output".equals(discriminatorValue)) {
                    responsesItem = ResponsesComputerCallOutputItem.fromJson(readerToUse.reset());
                    return responsesItem;
                }
                if ("file_search_call".equals(discriminatorValue)) {
                    responsesItem = ResponsesFileSearchCallItem.fromJson(readerToUse.reset());
                    return responsesItem;
                }
                if ("item_reference".equals(discriminatorValue)) {
                    responsesItem = ResponsesItemReferenceItem.fromJson(readerToUse.reset());
                    return responsesItem;
                }
                if ("web_search_call".equals(discriminatorValue)) {
                    responsesItem = ResponsesWebSearchCallItem.fromJson(readerToUse.reset());
                    return responsesItem;
                }
                if ("reasoning".equals(discriminatorValue)) {
                    responsesItem = ResponsesReasoningItem.fromJson(readerToUse.reset());
                    return responsesItem;
                }
                responsesItem = ResponsesItem.fromJsonKnownDiscriminator(readerToUse.reset());
                return responsesItem;
            }
        });
    }

    static ResponsesItem fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ResponsesItem)jsonReader.readObject(reader -> {
            ResponsesItem deserializedResponsesItem = new ResponsesItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedResponsesItem.type = ResponsesItemType.fromString(reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedResponsesItem.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResponsesItem;
        });
    }
}

