/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponseOutputTextAnnotationType;
import com.azure.ai.openai.responses.models.ResponsesOutputTextAnnotation;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesOutputTextAnnotationFileCitation
extends ResponsesOutputTextAnnotation {
    private ResponseOutputTextAnnotationType type = ResponseOutputTextAnnotationType.FILE_CITATION;
    private final int index;
    private final String fileId;

    @Override
    public ResponseOutputTextAnnotationType getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public String getFileId() {
        return this.fileId;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.index);
        jsonWriter.writeStringField("file_id", this.fileId);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesOutputTextAnnotationFileCitation fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesOutputTextAnnotationFileCitation)jsonReader.readObject(reader -> {
            int index = 0;
            String fileId = null;
            ResponseOutputTextAnnotationType type = ResponseOutputTextAnnotationType.FILE_CITATION;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("file_id".equals(fieldName)) {
                    fileId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponseOutputTextAnnotationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesOutputTextAnnotationFileCitation deserializedResponsesOutputTextAnnotationFileCitation = new ResponsesOutputTextAnnotationFileCitation(index, fileId);
            deserializedResponsesOutputTextAnnotationFileCitation.type = type;
            return deserializedResponsesOutputTextAnnotationFileCitation;
        });
    }

    public ResponsesOutputTextAnnotationFileCitation(int index, String fileId) {
        this.index = index;
        this.fileId = fileId;
    }
}

